from javawrap import GridBagConstraints
import DataAnalysis
import DataQuality
import InfectionEfficiency
import MainHandle
import MajorObjects
import Normalization
import RNAeyesLogin

# get the global handle:
masterObject = MainHandle.masterObject

def runRNAeyes(uName, authority, conn):
	import PlateSetSelection
	# top-level function for running RNAeyes using screening data stored in the database.
	print "in runRNAeyes (loading data from DB)"
	masterObject.setField('conn', conn)
	masterObject.setField('uName', uName)
	masterObject.setField('authority', authority)

	# create the main window:
	topWindow = MajorObjects.MainWindow(masterObject.getField('Software version'), conn, (1200, 950))
	masterObject.setField('topWindow', topWindow)
	masterObject.setField('errorPopup', MajorObjects.MessagePopup(topWindow))

	# add a JTabbedPane:
	# GridBagConstraints parameters:
	tConstraints = GridBagConstraints.newGridBagConstraints()
	tConstraints.gridx = 0
	tConstraints.gridy = 0
	tConstraints.gridwidth = 1
	tConstraints.gridheight = 1
	tConstraints.weightx = 1.0
	tConstraints.weighty = 1.0
	tConstraints.fill = GridBagConstraints.BOTH
	tConstraints.ipadx = 0
	tConstraints.ipady = 0
	topWindow.addTabbedPane(tConstraints)

	# create Plate set selection panel:
	#print 'Creating plateSetSelPanel'
	resetPwButton = MajorObjects.BorderedButton('Reset password', RNAeyesLogin.changePassword)
	plateSetSelPanel = PlateSetSelection.createPlateSetSelectionPanel('dummyUsername', resetPwButton)

	# create Infection Efficiency panel:
	#print 'Creating infectionEfficiencyPanel'
	infectionEfficiencyPanel = InfectionEfficiency.createInfectionEfficiencyPanel()

	# create Normalization panel:
	#print 'Creating normalizationPanel'
	normalizationPanel = Normalization.createNormalizationPanel()

	# create DataQuality panel:
	#print 'Creating dataQualityPanel'
	dataQualityPanel = DataQuality.createDataQualityPanel()

	# create Output panel:
	#print 'Creating outputPanel'
	analysisPanel = DataAnalysis.createAnalysisPanel()
	#print 'Done\n'

	# add all tool tabs:
	topWindow.addTab('Plate Set Selection', plateSetSelPanel)
	topWindow.addTab('Plate Scoring', normalizationPanel)
	topWindow.addTab('Infection Efficiency', infectionEfficiencyPanel)
	topWindow.addTab('Data Quality', dataQualityPanel)
	topWindow.addTab('Data Analysis', analysisPanel)

	# when switching tabs, check to make sure that the data being displayed is correct
	topWindow.addTabValidityCheck('Plate Scoring', Normalization.normValidateAnalysis)
	topWindow.addTabValidityCheck('Data Quality', Normalization.normValidateAnalysis)
	#topWindow.addTabValidityCheck('Infection Efficiency',ieValidateAnalysis)
	topWindow.addTabValidityCheck('Data Quality', DataQuality.executeDqAnalysis)
	topWindow.addTabValidityCheck('Data Analysis', DataAnalysis.getDataAnalysisData)

	tConstraints.gridy = 1
	tConstraints.fill = GridBagConstraints.NONE
	tConstraints.weighty = GridBagConstraints.REMAINDER
	tConstraints.anchor = GridBagConstraints.WEST

	topWindow.pack()

	# make the main window visible:
	topWindow.show()

def runRNAeyesFromFile():
	import PlateSetSelectFromFile
	# top-level function for running RNAeyes using data loaded from a flat file.
	# create the main window:
	topWindow = MajorObjects.MainWindow(masterObject.getField('Software version'), None, (1200, 950))
	masterObject.setField('topWindow', topWindow)
	masterObject.setField('errorPopup', MajorObjects.MessagePopup(topWindow))

	# add a JTabbedPane:
	# GridBagConstraints parameters:
	tConstraints = GridBagConstraints.newGridBagConstraints()
	tConstraints.gridx = 0
	tConstraints.gridy = 0
	tConstraints.gridwidth = 1
	tConstraints.gridheight = 1
	tConstraints.weightx = 1.0
	tConstraints.weighty = 1.0
	tConstraints.fill = GridBagConstraints.BOTH
	tConstraints.ipadx = 0
	tConstraints.ipady = 0
	topWindow.addTabbedPane(tConstraints)

	# create Plate data file selection panel:
	plateSetSelPanel = PlateSetSelectFromFile.createPlateFileLoadPanel()

	# create Infection Efficiency panel:
	infectionEfficiencyPanel = InfectionEfficiency.createInfectionEfficiencyPanel()

	# create Normalization panel:
	normalizationPanel = Normalization.createNormalizationPanel()

	# create DataQuality panel:
	dataQualityPanel = DataQuality.createDataQualityPanel()

	# create Output panel:
	analysisPanel = DataAnalysis.createAnalysisPanel()

	# add all tool tabs:
	topWindow.addTab('Plate Set Selection', plateSetSelPanel)
	topWindow.addTab('Plate Scoring', normalizationPanel)
	topWindow.addTab('Infection Efficiency', infectionEfficiencyPanel)
	topWindow.addTab('Data Quality', dataQualityPanel)
	topWindow.addTab('Data Analysis', analysisPanel)          # comment this line to disable Data Analysis tab

	topWindow.addTabValidityCheck('Plate Scoring', Normalization.normValidateAnalysis)
	topWindow.addTabValidityCheck('Data Quality', Normalization.normValidateAnalysis)
	topWindow.addTabValidityCheck('Data Quality', DataQuality.executeDqAnalysis)
	topWindow.addTabValidityCheck('Data Analysis', DataAnalysis.getDataAnalysisData)           # comment this line to disable Data Analysis tab

	tConstraints.gridy = 1
	tConstraints.fill = GridBagConstraints.NONE
	tConstraints.weighty = GridBagConstraints.REMAINDER
	tConstraints.anchor = GridBagConstraints.WEST

	topWindow.pack()

	# make the main window visible:
	topWindow.show()

if __name__ == "__main__":
	print 'Usage error: please run from main.py'


