from javawrap import Color, GridBagConstraints
import MainHandle
import MajorObjects
import Plotting
import java.awt.GridBagLayout as GridBagLayout
import javax.swing as swing
import javax.swing.BorderFactory as BorderFactory
import javax.swing.JPanel as JPanel
import org.jfree.chart.title.LegendTitle as LegendTitle
#from PlateSet import *

masterObject = MainHandle.masterObject

# standard borders for components:
emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1)
etchedBorder = BorderFactory.createEtchedBorder(swing.border.EtchedBorder.LOWERED)
loweredEtched = BorderFactory.createCompoundBorder(emptyBorder, etchedBorder)
MAX_TICKS_1 = 80
MAX_TICKS_2 = 100
PURO_PLUS_COLORS = [Color.newColor(255, 0, 0), Color.newColor(255, 200, 200), Color.newColor(255, 0, 255), Color.newColor(255, 150, 255), Color.newColor(255, 75, 50), Color.newColor(255, 200, 150), Color.newColor(220, 75, 75), Color.newColor(225, 150, 64), Color.newColor(200, 200, 200)]
PURO_MINUS_COLORS = [Color.newColor(0, 255, 0), Color.newColor(200, 255, 200), Color.newColor(0, 255, 255), Color.newColor(150, 255, 255), Color.newColor(75, 255, 50), Color.newColor(200, 255, 150), Color.newColor(75, 220, 75), Color.newColor(150, 225, 64), Color.newColor(150, 150, 150)]

# Main Data Quality tab construction
def createDataQualityPanel(debug=0):
	# create main frame:
	DPanel = MajorObjects.NewPanel()
	DPanel.setLayout(GridBagLayout())
	DConstraint = GridBagConstraints.newGridBagConstraints()
	DConstraint.fill = GridBagConstraints.BOTH
	DConstraint.weightx = 1.0
	DConstraint.weighty = 1.0

	# raw data box-and-whiskers box:
	(rawBwBox, compList) = makeNewBwBox('Raw Plate Statistics', 'Plate', 'Raw Data', 900, 300, 'rawBwBox')
	MainHandle.addToMasterObject(compList)

	# normalized data box-and-whiskers box:
	(normBwBox, compList) = makeNewBwBox('Plate Score Statistics', 'Plate', 'Score', 900, 300, 'normBwBox')
	MainHandle.addToMasterObject(compList)

	# selection of "all wells" or only "valid wells"
	(legendBox, compList) = makeLegendBox()
	MainHandle.addToMasterObject(compList)

	# add components to the panel:
	DConstraint.gridx = 0
	DConstraint.gridy = 0
	DPanel.add(rawBwBox, DConstraint)
	DConstraint.gridy = 1
	DPanel.add(normBwBox, DConstraint)
	DConstraint.gridy = 2
	DConstraint.weighty = 0.1
	DPanel.add(legendBox, DConstraint)

	DPanel.repaint()   # repaint the panel
	return DPanel

# raw data box-and-whiskers plot:
def makeRawBwBox(width, height):
	rawBwBox = Plotting.NewBoxAndWhiskerChart('Raw Plate Statistics', 'Plate', 'Raw Data', width, height)
	rawBwBox.setLabelRotation(60)      # x-axis labels at a 60-degree angle
	rawBwBox.setBorder(loweredEtched)
	return (rawBwBox, [['rawBwBox', rawBwBox]])

# 'all wells vs only valid wells selector box
def makeLegendBox():
	lPanel = JPanel()
	buttonList = ['all wells', 'only valid wells']
	allValidSelectBox = MajorObjects.RadioButtonUtils()
	allValidSelectBox.createRadioButtonGrouping(buttonList, 'Well statistics:',
											MajorObjects.CustomActionListener(wellStatsActionListener),
											defaultSelect=0, nCol=2)
	# set background color to very light gray
	allValidSelectBox.setButtonBgColor(Color.newColor(250, 250, 250))
	lPanel.add(allValidSelectBox.panel)
	return (allValidSelectBox.panel, [['allValidSelectBox', allValidSelectBox]])

# action listener for th legend box
def wellStatsActionListener(evt):
	if evt.getActionCommand() == 'only valid wells':
		executeDqAnalysis(evt, 0)                 # update the data quality analysis over only the valid wells
	elif evt.getActionCommand() == 'all wells':
		executeDqAnalysis(evt, 1)                 # update the data quality analysis over only all the wells

# box-and-whiskers plot container constructor
def makeNewBwBox(title, xlabel, ylabel, width, height, objectLabel):
	newBwBox = Plotting.BoxAndWhiskerChartCombo(title, ylabel, width, height, 0, 60)
	newBwBox.setBorder(loweredEtched)
	return (newBwBox, [[objectLabel, newBwBox]])

# AD: not used (debugging)
def makeExecuteButton():
	executeButtonPane = MajorObjects.BorderedButton('Execute Analysis', executeDqAnalysis)

	return (executeButtonPane, [['executeButtonPane', executeButtonPane],
							 ['executeButton', executeButtonPane.button]])

# action listener for data quality analysis
def executeDqAnalysis(event, allWells=1):
	plateSet = masterObject.getField('analysisPlateset')   # get the analysis plate set
	rawBwBox = masterObject.getField('rawBwBox')           # get the raw data box-and-whiskers container
	rawBwBox.resetChart()                                  # clear the chart
	normBwBox = masterObject.getField('normBwBox')         # get the normalized data box-and-whiskers container
	normBwBox.resetChart()                                 # clear the chart

	# get the sorted list of plate IDs
	plateIdList = plateSet.getPlateIdListSortedByVplate()
	# initialize maps, etc.:
	rawDataMap = {}
	rawColorMap = {}
	scoreDataMap = {}
	scoreColorMap = {}
	catIdList = {}
	condList = []
	catFill = {}
	lastVplateId = ''
	vPlateIdx = -1
	for plateId in plateIdList:
		plate = plateSet.getPlate(plateId)    # get the plate object

		# alternate colors to indicate groups of reads from the same virus plate:
		if plate.get_virusPlateId() != lastVplateId:
			lastVplateId = plate.get_virusPlateId()
			vPlateIdx += 1       # increment the virus plate index when a data from a new virus plate starts

		for readId in plate.get_readIdList():
			# display data for each assy of this plate
			if not plate.getAssay(readId).getUse():
				# if not using this plate, print a message
				print 'Not using: %s:%s' % (plateId, readId)
				continue

			(pData, pValid) = plate.getAssayData(readId) # get the assay data
			nData = plate.getNorm(readId)                # get the normalized assay data
			ieMask = plate.getIeMask()                   # get the IE mask
			vPlate = plate.virusPlate                    # get the virus plate object
			pName = plate.plateName                      # get the plate name
			bName = plate.batchName                      # get the batch name

			# get the condition index:
			cond = plate.getAssay(readId).get_condition()
			if condList.count(cond) == 0:
				condList.append(cond)
			condIdx = condList.index(cond)
			#print 'conditionList: ',condList
			if plate.isSelected():
				# puro+ plate:
				sStat = 'puro+'
			else:
				# puro- plate:
				sStat = 'puro-'

			if len(plate.get_readIdList()) > 1:
				# if more than one assay for this plate, append the assay condition to the plate name 
				catId = '%s:%s' % (pName, cond)
			else:
				# if only one assay, just use the plate name
				catId = pName

			catIdList.setdefault(bName, [])
			catIdList[bName].append(catId)

			rawColorMap.setdefault(bName, {})
			rawColorMap[bName].setdefault(catId, {})
			scoreColorMap.setdefault(bName, {})
			scoreColorMap[bName].setdefault(catId, {})

			if sStat == 'puro+':
				# set the fill color for puro+ plates to either red or pink
				rawColorMap[bName][catId]['raw'] = PURO_PLUS_COLORS[vPlateIdx % 2]      # raw data 
				scoreColorMap[bName][catId]['score'] = PURO_PLUS_COLORS[vPlateIdx % 2]  # normalized data
				catFill[catId] = 1      # AD: catFill doesn't appear to have any function
			else:
				# set the fill color for puro- plates to either green or light green
				rawColorMap[bName][catId]['raw'] = PURO_MINUS_COLORS[vPlateIdx % 2]     # raw data
				scoreColorMap[bName][catId]['score'] = PURO_MINUS_COLORS[vPlateIdx % 2] # normalized data
				catFill[catId] = 0      # AD: catFill doesn't appear to have any function

			# create a separate box-and-whiskers plot for each batch
			rawDataMap.setdefault(bName, {})
			rawDataMap[bName].setdefault(catId, {})
			rawDataMap[bName][catId]['raw'] = []
			for row in pData.keys():
				for col in pData[row].keys():
					# add data from each well to the data set for the plate
					if allWells or ieMask == None:
						# if "all wells" is selected or there is no IE mask entry for the well, add the data
						rawDataMap[bName][catId]['raw'].append(pData[row][col])
					elif ieMask[row][col] and vPlate.well[row][col].type == 1:
						# or, if ieMask==1 and this is a valid well, add the data
						rawDataMap[bName][catId]['raw'].append(pData[row][col])

			# create a separate box-and-whiskers plot for each batch
			scoreDataMap.setdefault(bName, {})
			scoreDataMap[bName].setdefault(catId, {})
			scoreDataMap[bName][catId]['score'] = []
			for row in pData.keys():
				for col in pData[row].keys():
					# add data from each well to the data set for the plate
					if allWells:
						# if "all wells" is selected or there is no IE mask entry for the well, add the data
						scoreDataMap[bName][catId]['score'].append(nData[row][col])
					elif ieMask[row][col] and vPlate.well[row][col].type == 1:
						# or, if ieMask==1 and this is a valid well, add the data
						scoreDataMap[bName][catId]['score'].append(nData[row][col])

	# get the list of batches and sort it:
	batchList = rawDataMap.keys()
	batchList.sort()

	# determine the total number of 'categories':
	nCat = 0.0
	for batch in batchList:
		nCat += float(len(catIdList[batch]))

	for batch in batchList:
		#weight = len(catIdList[batch]) / nCat
		# add a plot to the raw data panel
		rawBwBox.addBoxAndWhiskerPlot(batch, rawDataMap[batch], rawColorMap[batch],
									  catIdList[batch], ['raw'], catFill, len(catIdList[batch]))
		# add a plot to the normalized data panel
		normBwBox.addBoxAndWhiskerPlot(batch, scoreDataMap[batch], scoreColorMap[batch],
									   catIdList[batch], ['score'], catFill, len(catIdList[batch]))

	# adjust the size of the label font depending on how many "ticks" (plates) are displayed (AD: kind of a hack)
	if nCat > MAX_TICKS_1:
		print 'resizing rawBwBox font'
		rawBwBox.resizeLabelFont(0.8)
	if nCat > MAX_TICKS_2:
		print 'resizing rawBwBox font again'
		rawBwBox.resizeLabelFont(0.8)

	if nCat > MAX_TICKS_1:
		print 'resizing normBwBox font'
		normBwBox.resizeLabelFont(0.8)
	if nCat > MAX_TICKS_2:
		print 'resizing normBwBox font again'
		normBwBox.resizeLabelFont(0.8)

# AD: not used (debugging)
def printLegendContents(boxString):

	print 'Chart box: %s' % boxString
	print '         Chart: ', masterObject.getField(boxString).getChart()
	plot = masterObject.getField(boxString).getChart().getCategoryPlot()
	print '          Plot: ', plot
	print '      Renderer: ', plot.getRenderer()
	print '     label gen: ', plot.getRenderer().getBaseItemLabelGenerator()
	print 'lables visible: ', plot.getRenderer().getBaseItemLabelsVisible()
	print '   lable paint: ', plot.getRenderer().getBaseItemLabelPaint()
	print '       Legend : ', masterObject.getField(boxString).getChart().getLegend()
	print '     Container: ', masterObject.getField(boxString).getChart().getLegend().getItemContainer()
	print '      Sources : ', masterObject.getField(boxString).getChart().getLegend().getSources()[0]
	rawItemCollection = masterObject.getField(boxString).getChart().getLegend().getSources()[0].getLegendItems()
	print '        Items : ', rawItemCollection
	rIter = rawItemCollection.iterator()
	while rIter.hasNext():
		item = rIter.next()
		print '                  ', item
		print '             label: ', item.getLabel()
		print '             shape: ', item.getShape()
		print '         fillPaint: ', item.getFillPaint()
		print '    outline stroke: ', item.getOutlineStroke()
		print '     outline paint: ', item.getOutlinePaint()
		print ''
	print ' '

# AD: not used. I was never able to get a legend working.
def replaceLegend(boxString):
	chart = masterObject.getField(boxString).getChart()
	source = chart.getLegend().getSources()[0]
	newLegend = LegendTitle(source)


