from javawrap import GridBagConstraints
import MainHandle
import MajorObjects
import RNAeyes
import java
import java.awt.Color as Color
import java.awt.Dimension as Dimension
import java.awt.Insets as Insets
import java.awt.event.ActionListener as ActionListener
import javax.swing.JFrame as JFrame
import javax.swing.JLabel as JLabel
import javax.swing.JPasswordField as JPasswordField
import javax.swing.JTextField as JTextField
import oracle.jdbc.pool.OracleDataSource

masterObject = MainHandle.masterObject

MAXWRONG = 3
BGCOLOR = [Color(255, 255, 128), Color(255, 128, 128)]  # greenish-yellow, pink
LWARNINGS = ['Wrong. Try again...', 'Wrong again. One last try...'] # password warning messages

class ChangePwPanel(JFrame):
	# for changing a user's password
	def __init__(self, conn, size=[500, 150], location=[350, 350]):
		# create the "change password" window:
		JFrame.__init__(self, 'Change/Reset Password') #@UndefinedVariable
		self.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE)
		self.contentPane.layout = java.awt.GridBagLayout()

		# make the labels, entry fields, and buttons:
		self.uLabel = JLabel('  User Name: ')
		self.uLabel.setAlignmentX(1.0)
		pConstraints = GridBagConstraints.newGridBagConstraints()
		pConstraints.gridx = 0
		pConstraints.gridy = 0
		pConstraints.ipadx = 0
		pConstraints.ipady = 0
		pConstraints.gridwidth = 1
		pConstraints.gridheight = 1
		pConstraints.weightx = 0.35
		pConstraints.weighty = 1.0
		pConstraints.fill = GridBagConstraints.NONE
		pConstraints.anchor = GridBagConstraints.EAST
		self.contentPane.add(self.uLabel, pConstraints)

		# Username:
		self.uField = JTextField(10)
		self.uField.setAlignmentX(0.0)
		pConstraints.gridx = 1
		pConstraints.gridy = 0
		pConstraints.anchor = GridBagConstraints.WEST
		self.contentPane.add(self.uField, pConstraints)

		# Old password:
		self.pLabel = JLabel('Old password: ')
		self.pLabel.setAlignmentX(1.0)
		pConstraints.gridx = 0
		pConstraints.gridy = 1
		pConstraints.anchor = GridBagConstraints.EAST
		self.contentPane.add(self.pLabel, pConstraints)

		self.pField = JPasswordField(10)
		self.pField.setAlignmentX(0.0)
		pConstraints.gridx = 1
		pConstraints.gridy = 1
		pConstraints.anchor = GridBagConstraints.WEST
		self.contentPane.add(self.pField, pConstraints)

		# New password:
		self.n1Label = JLabel('New password: ')
		self.n1Label.setAlignmentX(1.0)
		pConstraints.gridx = 0
		pConstraints.gridy = 2
		pConstraints.anchor = GridBagConstraints.EAST
		self.contentPane.add(self.n1Label, pConstraints)

		self.n1Field = JPasswordField(10)
		self.n1Field.setAlignmentX(0.0)
		pConstraints.gridx = 1
		pConstraints.gridy = 2
		pConstraints.anchor = GridBagConstraints.WEST
		self.contentPane.add(self.n1Field, pConstraints)

		# New password (repeat):
		self.n2Label = JLabel('New password (again): ')
		self.n2Label.setAlignmentX(1.0)
		pConstraints.gridx = 0
		pConstraints.gridy = 3
		pConstraints.anchor = GridBagConstraints.EAST
		self.contentPane.add(self.n2Label, pConstraints)

		self.n2Field = JPasswordField(10)
		self.n2Field.setAlignmentX(0.0)
		pConstraints.gridx = 1
		pConstraints.gridy = 3
		pConstraints.anchor = GridBagConstraints.WEST
		self.contentPane.add(self.n2Field, pConstraints)

		self.lButtonPane = MajorObjects.BorderedButton('Change Password', changeLogin)
		self.lButtonPane.setAlignmentX(0.5)
		self.lButtonPane.setAlignmentY(0.5)
		self.lButtonPane.addKeyValuePair('conn', conn)
		self.lButtonPane.addKeyValuePair('uField', self.uField)
		self.lButtonPane.addKeyValuePair('pField', self.pField)
		self.lButtonPane.addKeyValuePair('n1Field', self.n1Field)
		self.lButtonPane.addKeyValuePair('n2Field', self.n2Field)
		self.lButtonPane.addKeyValuePair('lFrame', self)
		self.lButtonPane.addKeyValuePair('wrong', 0)

		# action performed when the button is "clicked"
		clicker = ButtonClicker(self.lButtonPane.button)
		self.pField.addActionListener(clicker)
		self.n2Field.addActionListener(clicker)

		pConstraints.anchor = GridBagConstraints.CENTER
		pConstraints.gridx = 2
		pConstraints.gridy = 0
		pConstraints.gridheight = 2
		pConstraints.weighty = GridBagConstraints.REMAINDER
		#pConstraints.ipadx = 10
		#pConstraints.ipady = 10
		pConstraints.insets = Insets(15, 10, 0, 10)
		self.contentPane.add(self.lButtonPane, pConstraints)

		self.cButtonPane = MajorObjects.BorderedButton('Cancel', cancelLogin)
		self.cButtonPane.setAlignmentX(0.5)
		self.cButtonPane.setAlignmentY(0.5)
		self.cButtonPane.addKeyValuePair('lFrame', self)
		ButtonClicker(self.cButtonPane.button)
		pConstraints.gridy = 2
		pConstraints.insets = Insets(0, 10, 15, 10)
		self.contentPane.add(self.cButtonPane, pConstraints)

		# set size and location:
		self.setPreferredSize(Dimension(size[0], size[1]))
		self.setSize(Dimension(size[0], size[1]))
		dLoc = self.getLocation()
		self.setLocation(int(dLoc.getX()) + location[0], int(dLoc.getY()) + location[1])

class LoginPanel(JFrame):
	# initial user login panel (requires a database connection to function)
	def __init__(self, title, conn, size=[360, 100], location=[450, 450]):
		# create login window
		JFrame.__init__(self, title=title) #@UndefinedVariable
		self.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE)
		self.contentPane.layout = java.awt.GridBagLayout()

		# make the labels, entry fields, and buttons:
		self.uLabel = JLabel('  User Name:')
		self.uLabel.setAlignmentX(1.0)
		self.pLabel = JLabel('   Password:')
		self.pLabel.setAlignmentX(1.0)
		self.uField = JTextField(15)
		self.uField.setAlignmentX(0.0)
		self.pField = JPasswordField(15)
		self.pField.setAlignmentX(0.0)
		self.lButtonPane = MajorObjects.BorderedButton('Log in', checkLogin)
		self.lButtonPane.setAlignmentX(0.5)
		self.lButtonPane.setAlignmentY(0.5)
		self.lButtonPane.addKeyValuePair('conn', conn)
		self.lButtonPane.addKeyValuePair('uField', self.uField)
		self.lButtonPane.addKeyValuePair('pField', self.pField)
		self.lButtonPane.addKeyValuePair('lFrame', self)
		self.lButtonPane.addKeyValuePair('wrong', 0)
		clicker = ButtonClicker(self.lButtonPane.button)
		self.pField.addActionListener(clicker)

		# lay out the window components
		pConstraints = GridBagConstraints.newGridBagConstraints() # start with the default component settings
		pConstraints.gridx = 0
		pConstraints.gridy = 0
		pConstraints.ipadx = 0
		pConstraints.ipady = 0
		pConstraints.gridwidth = 1
		pConstraints.gridheight = 1
		pConstraints.weightx = 0.25
		pConstraints.weighty = 0.5
		pConstraints.fill = GridBagConstraints.HORIZONTAL
		pConstraints.anchor = GridBagConstraints.EAST
		self.contentPane.add(self.uLabel, pConstraints)
		pConstraints.gridx = 0
		pConstraints.gridy = 1
		pConstraints.anchor = GridBagConstraints.EAST
		self.contentPane.add(self.pLabel, pConstraints)
		pConstraints.gridx = 1
		pConstraints.gridy = 0
		pConstraints.anchor = GridBagConstraints.WEST
		pConstraints.weightx = 0.5
		self.contentPane.add(self.uField, pConstraints)
		pConstraints.gridx = 1
		pConstraints.gridy = 1
		pConstraints.anchor = GridBagConstraints.WEST
		self.contentPane.add(self.pField, pConstraints)
		pConstraints.anchor = GridBagConstraints.CENTER
		pConstraints.gridx = 2
		pConstraints.gridy = 0
		pConstraints.gridheight = 2
		pConstraints.weighty = 0.5
		pConstraints.weightx = 0.25
		pConstraints.ipadx = 10
		pConstraints.ipady = 10
		self.contentPane.add(self.lButtonPane, pConstraints)

		# set size and location:
		self.setPreferredSize(Dimension(size[0], size[1]))
		self.setSize(Dimension(size[0], size[1]))
		dLoc = self.getLocation()
		self.setLocation(int(dLoc.getX()) + location[0], int(dLoc.getY()) + location[1])

class ButtonClicker(ActionListener):
	# performs a "doClick()" action when invoked
	def __init__(self, button):
		self.button = button

	def actionPerformed(self, evt):
		self.button.doClick()

def checkLogin(evt):
	# check the password that the user types in against the (encoded) password in 
	# the database. Give the user 3 tries. If login fails, the program exits
	button = evt.getSource()
	conn = button.getValue('conn')
	uText = button.getValue('uField').getText()    # the username entered by the user
	pText = button.getValue('pField').getText()    # the password entered by the user
	lFrame = button.getValue('lFrame')
	bPane = button.getValue('bPane')

	passwdE = pwEncode(pText)  # encode the password entered by the user

	# get the encoded password from the database, using the username as the key from the PASSWD table:
	pQry = conn.prepareStatement('select p.passwd, p.authority from PASSWD p where p.loginname=?')
	pQry.setString(1, uText)
	rs = pQry.executeQuery()
	passwd = 'None'
	authority = 'None'
	# read the password and user authority from the database:
	# authority is current either 'all' or 'screener'
	while rs.next():
		passwd = rs.getInt(1)
		authority = rs.getString(2)

	if passwd == passwdE:
		# if the encoded password in the DB matches the encoded password entered, run the program:
		lFrame.dispose()
		RNAeyes.runRNAeyes(uText, authority, conn)

	else:
		# if the user entered the wrong password, increment "wrongs" counter, display the warning message, 
		# and give the user another chance.
		wrongs = button.getValue('wrong')
		if wrongs + 1 >= MAXWRONG:
			# if the number of tries exceed the maximum, exit the program:
			lFrame.dispose()
		else:
			# change to the next warning color, and give the user another chance
			button.setKeyValuePair('wrong', wrongs + 1)
			lFrame.contentPane.setBackground(BGCOLOR[wrongs])
			lFrame.setTitle(LWARNINGS[wrongs])
			bPane.setBackground(BGCOLOR[wrongs])

def changeLogin(evt):
	# process the request to change password:

	# first, go through the same login procedure as if logging in:
	button = evt.getSource()
	conn = button.getValue('conn')
	uText = button.getValue('uField').getText()
	pText = button.getValue('pField').getText()
	lFrame = button.getValue('lFrame')
	bPane = button.getValue('bPane')

	# encode the password text using lame password encoder
	passwdE = pwEncode(pText)

	# set up password query
	pQry = conn.prepareStatement('select p.passwd, p.authority from PASSWD p where p.loginname=?')
	pQry.setString(1, uText)
	rs = pQry.executeQuery()
	passwd = 'None'
	authority = 'None'
	while rs.next():
		passwd = rs.getInt(1)
		authority = rs.getString(2)

	# validate old password:
	if passwd != passwdE:
		wrongs = button.getValue('wrong')
		if wrongs + 1 >= MAXWRONG:
			lFrame.dispose()
		else:
			button.setKeyValuePair('wrong', wrongs + 1)
			lFrame.contentPane.setBackground(BGCOLOR[wrongs])
			lFrame.setTitle(LWARNINGS[wrongs])
			bPane.setBackground(BGCOLOR[wrongs])
		return

	print "Login successful"

	# After cheking that the username and password are correct, 
	# check consistency of new passwords:
	n1Text = button.getValue('n1Field').getText()
	n2Text = button.getValue('n2Field').getText()
	if n1Text != n2Text:
		# if the new password doesn't match the re-typed password, give the user another try:
		lFrame.setTitle('Inconsistent new password!')
		lFrame.contentPane.setBackground(BGCOLOR[0])
		bPane.setBackground(BGCOLOR[0])
		button.getValue('n1Field').setText('')
		button.getValue('n2Field').setText('')
		return
	elif n1Text == '':
		# if the user doesn't type in a new password, give them another try:
		lFrame.setTitle('You must set a password!')
		lFrame.contentPane.setBackground(BGCOLOR[1])
		bPane.setBackground(BGCOLOR[1])
		return

	# if the passwords match, encode the new password and save it to the DB:
	pUpdate = conn.prepareStatement('update PASSWD p set p.passwd=? where p.loginname=?')
	passwdE = pwEncode(n1Text)
	pUpdate.setInt(1, passwdE)
	pUpdate.setString(2, uText)
	pUpdate.executeUpdate()

	print "Change successful"

	lFrame.dispose()   # close the update password window

def cancelLogin(evt):
	# if login is canceled, close the window and exit
	button = evt.getSource()
	lFrame = button.getValue('lFrame')
	lFrame.dispose()

def pwEncode(text):
	# extremely lame password encoding:
	# To compute the encoded password, get the alphabetic value of each 
	#  character of the password (using the Python ord() function), then multiply each letter 
	#  by 2^(position in the login string).
	#  e.g., if the password is 'ABC', ord('A')=65, ord('B')=66, and ord('C')=67, so the encode
	#  password would be 65*2^2 + 66*2^1 + 67*2^0, or 459 
	pVal = 0
	for i in range(len(text)):
		pVal += ord(text[-(i + 1)]) * pow(2, i)

	return int(pVal)

def popUpLogin(conn):
	# pop up the login panel:
	lFrame = LoginPanel('RNAeyes login', conn)
	lFrame.show()

def changePassword(evt):
	# pop up the changePassword panel. This panel requires a connection to the 
	# database to allow it to check the password against the password stored in the DB.
	conn = masterObject.getField('conn')
	cFrame = ChangePwPanel(conn)
	cFrame.show()

def runRNAeyesLogin(args=None):
	# Function for user login to RNAeyes. 
	# The function can accept eiter -dev or -debug as optional input flags. 
	#	-debug: simply sets a global 'debugging' field to 1 (normal default is 0) This variable can be 
	#			accessed anywhere within the program to cause some debugging action to happen.
	#	-dev: creates a connection to the development database, rather than the (default) production database

	# This is also where the connection to the database is made. 
	# conn is the jdbc database connection handle used for all database communications within RNAeyes.
	# Unfortunately, the user name and password for the connection are hard-coded and in the clear
	# in this source code. 

	# connect to the DB:
	ods = oracle.jdbc.pool.OracleDataSource()

	if args == '-debug':
		masterObject.setField('debugging', 1)
	else:
		masterObject.setField('debugging', 0)

	#ods.setUser("derr")
	#ods.setPassword("oracle")
	if args == '-dev':
		# set up connection to the DEV database:
		ods.setUser("trc_broad")
		dbName = "trc_broad"
		ods.setPassword("broad")
		ods.setURL("jdbc:oracle:thin:@rnaidev:1521:rnai_dev")
	else:
		# set up connection to the PROD database:
		# currently this must be WRITE access because user can change their login password
		ods.setUser("trc_broad")
		dbName = "trc_broad"
		ods.setPassword("8R04dP")
		ods.setURL("jdbc:oracle:thin:@rnaiprod:1521:rnaiprod")

	# make the DB connection
	conn = ods.getConnection()
	print 'Database connection to %s successful.' % dbName.upper()

	# pop up the login window and pass it the database connection:
	# >>> NOTE: another approach could be setting conn as a global in the masterObject
	#		(using masterObject.setField("DBconnection", conn))
        #RNAeyes.runRNAeyes("sullivan", "all", conn)
	popUpLogin(conn)

