/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CommitToken;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.PropUtil;
import java.util.concurrent.TimeUnit;

public class Transaction {
    private Txn txn;
    private final Environment env;
    private final long id;
    private String name;
    private CommitToken commitToken = null;

    protected Transaction(Environment env, Txn txn) {
        this.env = env;
        this.txn = txn;
        txn.setTransaction(this);
        this.id = txn.getId();
    }

    public synchronized void abort() throws DatabaseException {
        try {
            this.checkEnv();
            if (this.txn == null) {
                return;
            }
            this.env.removeReferringHandle(this);
            this.txn.abort();
            this.txn = null;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.env).invalidate(E);
            throw E;
        }
    }

    public long getId() {
        return this.id;
    }

    public CommitToken getCommitToken() throws IllegalStateException {
        if (this.txn == null) {
            return this.commitToken;
        }
        throw new IllegalStateException("This transaction is still in progress and a commit token is not available");
    }

    public synchronized void commit() throws DatabaseException {
        try {
            this.checkEnv();
            this.checkOpen();
            this.env.removeReferringHandle(this);
            this.txn.commit();
            this.commitToken = this.txn.getCommitToken();
            this.txn = null;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.env).invalidate(E);
            throw E;
        }
    }

    public synchronized void commit(Durability durability) throws DatabaseException {
        this.doCommit(durability, false);
    }

    public synchronized void commitSync() throws DatabaseException {
        this.doCommit(Durability.COMMIT_SYNC, true);
    }

    public synchronized void commitNoSync() throws DatabaseException {
        this.doCommit(Durability.COMMIT_NO_SYNC, true);
    }

    public synchronized void commitWriteNoSync() throws DatabaseException {
        this.doCommit(Durability.COMMIT_WRITE_NO_SYNC, true);
    }

    public boolean getPrepared() {
        return this.txn.getPrepared();
    }

    private void doCommit(Durability durability, boolean explicitSync) {
        try {
            this.checkEnv();
            this.checkOpen();
            this.env.removeReferringHandle(this);
            if (explicitSync) {
                if (this.txn.getExplicitDurabilityConfigured()) {
                    throw new IllegalArgumentException("Mixed use of deprecated durability API for the transaction commit with the new durability API for TransactionConfig or MutableEnvironmentConfig");
                }
            } else if (this.txn.getExplicitSyncConfigured()) {
                throw new IllegalArgumentException("Mixed use of new durability API for the transaction commit with deprecated durability API for TransactionConfig or MutableEnvironmentConfig");
            }
            this.txn.commit(durability);
            this.commitToken = this.txn.getCommitToken();
            this.txn = null;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.env).invalidate(E);
            throw E;
        }
    }

    public long getTxnTimeout(TimeUnit unit) throws EnvironmentFailureException, IllegalStateException, IllegalArgumentException {
        this.checkEnv();
        this.checkOpen();
        return PropUtil.millisToDuration((int)this.txn.getTxnTimeout(), unit);
    }

    public void setTxnTimeout(long timeOut, TimeUnit unit) throws IllegalArgumentException, DatabaseException {
        this.checkEnv();
        this.checkOpen();
        this.txn.setTxnTimeout(PropUtil.durationToMillis(timeOut, unit));
    }

    public void setTxnTimeout(long timeOut) throws IllegalArgumentException, DatabaseException {
        this.setTxnTimeout(timeOut, TimeUnit.MICROSECONDS);
    }

    public long getLockTimeout(TimeUnit unit) throws EnvironmentFailureException, IllegalStateException, IllegalArgumentException {
        this.checkEnv();
        this.checkOpen();
        return PropUtil.millisToDuration((int)this.txn.getLockTimeout(), unit);
    }

    public void setLockTimeout(long timeOut, TimeUnit unit) throws IllegalArgumentException, DatabaseException {
        this.checkEnv();
        this.checkOpen();
        this.txn.setLockTimeout(PropUtil.durationToMillis(timeOut, unit));
    }

    public void setLockTimeout(long timeOut) throws IllegalArgumentException, DatabaseException {
        this.setLockTimeout(timeOut, TimeUnit.MICROSECONDS);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        return ((Transaction)o).id == this.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Transaction id=\"");
        sb.append(this.id).append("\"");
        if (this.name != null) {
            sb.append(" name=\"");
            sb.append(this.name).append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    Locker getLocker() throws DatabaseException {
        if (this.txn == null) {
            throw new IllegalArgumentException("Transaction " + this.id + " has been closed and is no longer usable.");
        }
        return this.txn;
    }

    Txn getTxn() {
        return this.txn;
    }

    Environment getEnvironment() {
        return this.env;
    }

    private void checkEnv() {
        EnvironmentImpl envImpl = this.env.getEnvironmentImpl();
        if (envImpl == null) {
            throw new IllegalStateException("The environment has been closed. This transaction is no longer usable.");
        }
        envImpl.checkIfInvalid();
    }

    void checkOpen() {
        if (this.txn == null || this.txn.isClosed()) {
            throw new IllegalStateException("Transaction Id " + this.id + " has been closed.");
        }
    }

    public boolean isValid() {
        return this.txn != null && this.txn.isValid();
    }
}

