/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.sync.impl;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.sync.impl.LogChangeSet;
import com.sleepycat.je.sync.impl.SyncDB;
import com.sleepycat.je.trigger.ReplicatedDatabaseTrigger;
import com.sleepycat.je.trigger.TransactionTrigger;
import com.sleepycat.je.trigger.Trigger;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class SyncCleanerBarrier {
    private final EnvironmentImpl envImpl;
    private final Map<String, Long> syncStarts = new HashMap<String, Long>();
    private long minSyncStart = 0L;

    public SyncCleanerBarrier(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
    }

    public void init(Environment env) {
        SyncDB syncDb;
        if (this.envImpl.isReadOnly()) {
            return;
        }
        try {
            syncDb = new SyncDB(this.envImpl, false);
        }
        catch (DatabaseNotFoundException e) {
            return;
        }
        Map<String, DatabaseEntry> changeSets = syncDb.readDataForType(SyncDB.DataType.CHANGE_SET, env);
        if (changeSets == null || changeSets.size() == 0) {
            return;
        }
        LogChangeSet.LogChangeSetBinding binding = new LogChangeSet.LogChangeSetBinding();
        long minValue = Long.MAX_VALUE;
        for (Map.Entry<String, DatabaseEntry> entry : changeSets.entrySet()) {
            LogChangeSet changeSet = (LogChangeSet)binding.entryToObject(entry.getValue());
            this.syncStarts.put(entry.getKey(), changeSet.getNextSyncStart());
            if (this.doCompare(minValue, changeSet.getNextSyncStart()) <= 0) continue;
            minValue = changeSet.getNextSyncStart();
        }
        if (minValue != Long.MAX_VALUE) {
            this.minSyncStart = minValue;
        }
    }

    private int doCompare(long value1, long value2) {
        if (this.envImpl.isReplicated()) {
            return new VLSN(value1).compareTo(new VLSN(value2));
        }
        return DbLsn.compareTo(value1, value2);
    }

    synchronized void updateSyncStart(String key, StartInfo startInfo) {
        boolean firstDataSet;
        long syncStart = startInfo.getNextSyncStart();
        boolean bl = firstDataSet = this.syncStarts.size() == 0;
        if (this.doCompare(syncStart, this.minSyncStart) < 0) {
            StringTokenizer tokenizer = new StringTokenizer(key, "-");
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Invalid behavior, Processor: " + tokenizer.nextToken() + ", SyncDataSet: " + tokenizer.nextToken() + " is reading log entries on file " + "smaller than cleaner barrier file: " + this.envImpl.getCleanerBarrierStartFile() + " at " + (this.envImpl.isReplicated() ? "VLSN: " + syncStart : "lsn: " + DbLsn.getNoFormatString(syncStart)));
        }
        if (startInfo.isDelete()) {
            this.syncStarts.remove(key);
        } else {
            this.syncStarts.put(key, syncStart);
        }
        if (this.syncStarts.size() == 0) {
            this.minSyncStart = 0L;
            return;
        }
        long minValue = Long.MAX_VALUE;
        for (Map.Entry<String, Long> entry : this.syncStarts.entrySet()) {
            if (this.doCompare(minValue, entry.getValue()) <= 0) continue;
            minValue = entry.getValue();
        }
        assert (minValue != Long.MAX_VALUE);
        this.minSyncStart = minValue;
        if (this.envImpl.isMaster() && firstDataSet) {
            this.envImpl.unfreezeLocalCBVLSN();
        }
    }

    public synchronized long getSyncStart(String key) {
        assert (this.syncStarts.containsKey(key));
        return this.syncStarts.get(key);
    }

    public synchronized long getMinSyncStart() {
        return this.minSyncStart;
    }

    public synchronized boolean isFirstSyncDataSet() {
        return this.syncStarts.size() == 0;
    }

    static class StartInfo {
        private final long nextSyncStart;
        private final boolean isDelete;

        public StartInfo(long nextSyncStart, boolean isDelete) {
            this.nextSyncStart = nextSyncStart;
            this.isDelete = isDelete;
        }

        public long getNextSyncStart() {
            return this.nextSyncStart;
        }

        public boolean isDelete() {
            return this.isDelete;
        }
    }

    public static class SyncTrigger
    implements Trigger,
    TransactionTrigger,
    ReplicatedDatabaseTrigger {
        private transient Map<Long, Map<String, StartInfo>> txnIdToSyncStarts;
        private final String triggerName;
        private transient SyncCleanerBarrier barrier;
        private transient String dbName;

        public SyncTrigger(String triggerName) {
            this.triggerName = triggerName;
        }

        public String getName() {
            return this.triggerName;
        }

        public Trigger setDatabaseName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public String getDatabaseName() {
            return this.dbName;
        }

        public void addTrigger(Transaction txn) {
        }

        public void removeTrigger(Transaction txn) {
        }

        public void open(Transaction txn, Environment environment, boolean isNew) {
            this.barrier = DbInternal.getEnvironmentImpl(environment).getSyncCleanerBarrier();
            assert (this.barrier != null);
            this.txnIdToSyncStarts = new ConcurrentHashMap<Long, Map<String, StartInfo>>();
        }

        public void close() {
        }

        public void remove(Transaction txn) {
        }

        public void truncate(Transaction txn) {
        }

        public void rename(Transaction txn, String newName) {
        }

        public void put(Transaction txn, DatabaseEntry key, DatabaseEntry oldData, DatabaseEntry newData) {
            this.addNewMapEntry(txn, key, newData, false);
        }

        private void addNewMapEntry(Transaction txn, DatabaseEntry key, DatabaseEntry data, boolean isDelete) {
            String dataSetName = StringBinding.entryToString(key);
            if (SyncDB.DataType.getDataType(dataSetName) == SyncDB.DataType.CHANGE_SET) {
                Map<String, StartInfo> syncStartInfos = this.txnIdToSyncStarts.get(txn.getId());
                if (syncStartInfos == null) {
                    syncStartInfos = new ConcurrentHashMap<String, StartInfo>();
                    this.txnIdToSyncStarts.put(txn.getId(), syncStartInfos);
                }
                LogChangeSet.LogChangeSetBinding binding = new LogChangeSet.LogChangeSetBinding();
                LogChangeSet set = (LogChangeSet)binding.entryToObject(data);
                StartInfo startInfo = new StartInfo(set.getNextSyncStart(), isDelete);
                syncStartInfos.put(dataSetName, startInfo);
            }
        }

        public void delete(Transaction txn, DatabaseEntry key, DatabaseEntry oldData) {
            this.addNewMapEntry(txn, key, oldData, true);
        }

        public void commit(Transaction txn) {
            Map<String, StartInfo> syncStartInfos = this.txnIdToSyncStarts.get(txn.getId());
            if (syncStartInfos != null) {
                for (Map.Entry<String, StartInfo> entry : syncStartInfos.entrySet()) {
                    this.barrier.updateSyncStart(entry.getKey(), entry.getValue());
                }
            }
            this.txnIdToSyncStarts.remove(txn.getId());
        }

        public void abort(Transaction txn) {
            this.txnIdToSyncStarts.remove(txn.getId());
        }

        public void repeatTransaction(Transaction txn) {
        }

        public void repeatAddTrigger(Transaction txn) {
        }

        public void repeatRemoveTrigger(Transaction txn) {
        }

        public void repeatCreate(Transaction txn) {
        }

        public void repeatRemove(Transaction txn) {
        }

        public void repeatTruncate(Transaction txn) {
        }

        public void repeatRename(Transaction txn, String newName) {
        }

        public void repeatPut(Transaction txn, DatabaseEntry key, DatabaseEntry newData) {
        }

        public void repeatDelete(Transaction txn, DatabaseEntry key) {
        }
    }
}

