/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoReader {
    public final LNLogEntry logEntry;
    public final LN ln;
    private final long lsn;
    public final DatabaseImpl db;
    private final DbTree dbMapTree;

    public UndoReader(EnvironmentImpl envImpl, long undoLsn, Map<DatabaseId, DatabaseImpl> undoDatabases) {
        this.logEntry = (LNLogEntry)envImpl.getLogManager().getLogEntryHandleFileNotFound(undoLsn);
        DatabaseId dbId = this.logEntry.getDbId();
        this.db = undoDatabases.get(dbId);
        this.logEntry.postFetchInit(this.db);
        this.ln = this.logEntry.getLN();
        this.lsn = undoLsn;
        this.ln.postFetchInit(this.db, undoLsn);
        this.dbMapTree = null;
    }

    public UndoReader(LNFileReader reader, DbTree dbMapTree) {
        this.logEntry = reader.getLNLogEntry();
        DatabaseId dbId = this.logEntry.getDbId();
        this.dbMapTree = dbMapTree;
        this.db = dbMapTree.getDb(dbId);
        this.logEntry.postFetchInit(this.db);
        this.ln = this.logEntry.getLN();
        this.lsn = reader.getLastLsn();
        this.ln.postFetchInit(this.db, this.lsn);
    }

    public void releaseDb() {
        this.dbMapTree.releaseDb(this.db);
    }

    public String toString() {
        return this.ln + " lsn=" + DbLsn.getNoFormatString(this.lsn);
    }
}

