/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;

public class DbBackup {
    private EnvironmentImpl envImpl;
    private boolean backupStarted;
    private long lastFileInBackup = -1L;
    private long firstFileInBackup;
    private boolean envIsReadOnly;
    private boolean invalid;
    private long rollbackStartedFileNumber;
    private TestHook testHook;

    public DbBackup(Environment env) throws DatabaseException {
        this(env, -1L);
    }

    public DbBackup(Environment env, long lastFileInPrevBackup) throws DatabaseException {
        env.checkHandleIsValid();
        this.init(DbInternal.getEnvironmentImpl(env), lastFileInPrevBackup);
    }

    public DbBackup(EnvironmentImpl envImpl) throws DatabaseException {
        this.init(envImpl, -1L);
    }

    private void init(EnvironmentImpl envImpl, long lastFileInPrevBackup) throws DatabaseException {
        this.envImpl = envImpl;
        FileManager fileManager = envImpl.getFileManager();
        this.envIsReadOnly = fileManager.checkEnvHomePermissions(true);
        if (!this.envIsReadOnly && envImpl.isReadOnly()) {
            throw new IllegalArgumentException("Environment handle may not be read-only when directory is read-write");
        }
        this.firstFileInBackup = lastFileInPrevBackup + 1L;
    }

    public synchronized void startBackup() throws DatabaseException {
        if (this.backupStarted) {
            throw new IllegalStateException("startBackup was already called");
        }
        if (!this.envImpl.addDbBackup(this)) {
            throw this.envImpl.createLogOverwriteException("A replication operation is overwriting log files. The backup can not proceed because files may be invalid. The backup may be attempted at a later time.");
        }
        this.envImpl.getCleaner().addProtectedFileRange(this.firstFileInBackup);
        this.backupStarted = true;
        if (this.envIsReadOnly) {
            FileManager fileManager = this.envImpl.getFileManager();
            this.lastFileInBackup = fileManager.getLastFileNum();
        } else {
            long newFileLsn = this.envImpl.forceLogFileFlip();
            this.lastFileInBackup = DbLsn.getFileNumber(newFileLsn) - 1L;
        }
    }

    public synchronized void endBackup() {
        this.checkBackupStarted();
        this.backupStarted = false;
        assert (TestHookExecute.doHookIfSet(this.testHook));
        this.envImpl.getCleaner().removeProtectedFileRange(this.firstFileInBackup);
        this.envImpl.removeDbBackup(this);
        if (this.invalid) {
            this.invalid = false;
            throw this.envImpl.createLogOverwriteException("A replication operation has overwritten log files from file " + this.rollbackStartedFileNumber + ". Any copied files " + "should be considered invalid and discarded. The backup " + "may be attempted at a later time.");
        }
    }

    public synchronized long getLastFileInBackupSet() {
        this.checkBackupStarted();
        return this.lastFileInBackup;
    }

    public synchronized String[] getLogFilesInBackupSet() {
        this.checkBackupStarted();
        return this.envImpl.getFileManager().listFileNames(this.firstFileInBackup, this.lastFileInBackup);
    }

    public synchronized String[] getLogFilesInBackupSet(long lastFileInPrevBackup) {
        this.checkBackupStarted();
        FileManager fileManager = this.envImpl.getFileManager();
        return fileManager.listFileNames(lastFileInPrevBackup + 1L, this.lastFileInBackup);
    }

    private void checkBackupStarted() {
        if (!this.backupStarted) {
            throw new IllegalStateException("startBackup was not called");
        }
    }

    public synchronized boolean backupIsOpen() {
        return this.backupStarted;
    }

    public void invalidate(long fileNumber) {
        this.invalid = true;
        this.rollbackStartedFileNumber = fileNumber;
    }

    public void setTestHook(TestHook testHook) {
        this.testHook = testHook;
    }
}

