/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.utilint;

import com.sleepycat.utilint.Latency;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class LatencyStat
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private final int maxTrackedLatencyMillis;
    private AtomicIntegerArray histogram;
    private volatile long totalNanos;
    private volatile long max;
    private volatile long min = Long.MAX_VALUE;
    private volatile AtomicInteger opsOverflow;
    private volatile AtomicInteger numOps;
    private int saveMin;
    private int saveMax;
    private float saveAvg;
    private int saveNumOps;
    private int save95;
    private int save99;
    private int saveOpsOverflow;

    public LatencyStat(long maxTrackedLatencyMillis) {
        this.maxTrackedLatencyMillis = (int)maxTrackedLatencyMillis;
        this.clear();
    }

    public synchronized void clear() {
        this.histogram = new AtomicIntegerArray(this.maxTrackedLatencyMillis);
        this.numOps = new AtomicInteger();
        this.opsOverflow = new AtomicInteger();
        this.totalNanos = 0L;
        this.max = 0L;
        this.min = Long.MAX_VALUE;
    }

    public Latency calculate() {
        return this.calculate(false);
    }

    public Latency calculateAndClear() {
        return this.calculate(true);
    }

    private synchronized Latency calculate(boolean clear) {
        long useTotalNanos = this.totalNanos;
        int totalOps = this.numOps.get();
        int nOverflow = this.opsOverflow.get();
        int minIncludingOverflow = (int)this.min;
        int maxIncludingOverflow = (int)this.max;
        if (totalOps == 0) {
            return new Latency(this.maxTrackedLatencyMillis, 0, 0, 0.0f, 0, 0, 0, 0);
        }
        int percent95 = -1;
        int percent99 = -1;
        if (minIncludingOverflow < this.maxTrackedLatencyMillis) {
            int percent95Count = (int)((double)(totalOps - nOverflow) * 0.95);
            int percent99Count = (int)((double)(totalOps - nOverflow) * 0.99);
            int numSamplesSeen = 0;
            for (int latency = 0; latency < this.histogram.length() && numSamplesSeen < percent99Count; ++latency) {
                int count = this.histogram.get(latency);
                if (count == 0) continue;
                if (numSamplesSeen < percent95Count) {
                    percent95 = latency;
                }
                percent99 = latency;
                numSamplesSeen += count;
            }
        }
        float avgMs = (float)((double)useTotalNanos * 1.0E-6) / (float)totalOps;
        this.saveMax = maxIncludingOverflow;
        this.saveMin = minIncludingOverflow;
        this.saveAvg = avgMs;
        this.saveNumOps = totalOps;
        this.save95 = percent95;
        this.save99 = percent99;
        this.saveOpsOverflow = nOverflow;
        if (clear) {
            this.clear();
        }
        return new Latency(this.maxTrackedLatencyMillis, this.saveMin, this.saveMax, this.saveAvg, this.saveNumOps, this.save95, this.save99, this.saveOpsOverflow);
    }

    public void set(long nanoLatency) {
        this.set(1, nanoLatency);
    }

    public void set(int numRecordedOps, long nanoLatency) {
        this.numOps.addAndGet(numRecordedOps);
        this.totalNanos += nanoLatency;
        long useLatency = nanoLatency / (long)numRecordedOps;
        int millisRounded = (int)((useLatency + 500000L) / 1000000L);
        if (millisRounded >= this.maxTrackedLatencyMillis) {
            this.opsOverflow.incrementAndGet();
        } else {
            this.histogram.incrementAndGet(millisRounded);
        }
        if (this.max < (long)millisRounded) {
            this.max = millisRounded;
        }
        if (this.min > (long)millisRounded) {
            this.min = millisRounded;
        }
    }

    public synchronized void rollup(LatencyStat other) {
        if (other == null || other == this) {
            throw new IllegalStateException("Can't rollup a LatencyStat that doesn't have any data");
        }
        if (other.maxTrackedLatencyMillis != this.maxTrackedLatencyMillis) {
            throw new IllegalStateException("Can't rollup a LatencyStat whose maxTrackedLatencyMillis is different");
        }
        this.totalNanos += other.totalNanos;
        this.numOps.addAndGet(other.numOps.get());
        this.opsOverflow.addAndGet(other.opsOverflow.get());
        if (this.max < other.max) {
            this.max = other.max;
        }
        for (int latency = 0; latency < this.histogram.length(); ++latency) {
            this.histogram.addAndGet(latency, other.histogram.get(latency));
        }
    }

    public boolean isEmpty() {
        return this.numOps.get() == 0;
    }

    public String toString() {
        Latency results = new Latency(this.maxTrackedLatencyMillis, this.saveMin, this.saveMax, this.saveAvg, this.saveNumOps, this.save95, this.save99, this.saveOpsOverflow);
        return results.toString();
    }
}

