/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.cli;

import org.broadinstitute.rnai.poolq.api.PoolQFilenameInputs;

public class PoolQOptionsSummary {
    public String buildOptionsSummary(PoolQFilenameInputs inputs) {
        String unexpectedSequenceFile;
        String barcodeScoresFile;
        StringBuilder builder = new StringBuilder();
        builder.append("PoolQ runtime configuration summary\n");
        builder.append("Input files:\n");
        builder.append("\tConditions file:         ").append(inputs.getConditionsFilename()).append('\n');
        builder.append("\tReference file:          ").append(inputs.getReferenceFilename()).append('\n');
        builder.append("\tReads file:              ").append(inputs.getReadsFilename()).append('\n');
        builder.append("\tReads file type:         ").append((Object)inputs.getReadsFileType()).append('\n');
        String platformReference = inputs.getPlatformReferenceFilename();
        if (platformReference != null) {
            builder.append("Platform Reference file: ").append(platformReference).append('\n');
        }
        builder.append('\n');
        builder.append("Options:\n");
        if (inputs.requireExactMatch()) {
            builder.append("\tExact matching for hairpins\n");
        } else {
            builder.append("\tAllow 1-base mismatches for hairpins\n");
        }
        if (inputs.includeAmbiguous()) {
            builder.append("\tCount reads for all 1-base mismatches\n");
        } else {
            builder.append("\tDiscard reads with ambiguous 1-base mismatches\n");
        }
        if (inputs.includeNonPfReads()) {
            builder.append("\tInclude reads failing purity filter\n");
        } else {
            builder.append("\tDiscard reads failing purity filter\n");
        }
        builder.append('\n');
        builder.append("Read structure:\n");
        builder.append("\tBarcode start index: ").append(inputs.getBarcodeStartIndex()).append('\n');
        builder.append("\tHairpin start index: ").append(inputs.getHairpinStartIndex()).append('\n');
        builder.append('\n');
        builder.append("Output files:\n");
        builder.append("\tQuality file:               ").append(inputs.getQualityFilename()).append('\n');
        builder.append("\tScores file:                ").append(inputs.getScoresFilename()).append('\n');
        String logNormalizedFile = inputs.getLogNormalizedScoresFilename();
        if (logNormalizedFile != null) {
            builder.append("\tLog-Normalized Scores file: ").append(logNormalizedFile).append('\n');
        }
        if ((barcodeScoresFile = inputs.getBarcodeScoresFilename()) != null) {
            builder.append("\tBarcode scores file:        ").append(barcodeScoresFile).append('\n');
        }
        if ((unexpectedSequenceFile = inputs.getUnexpectedSequenceFilename()) != null) {
            builder.append("\tUnexpected sequence file:   ").append(unexpectedSequenceFile).append('\n');
            builder.append("\tIncluding unexpected sequences occurring at least ");
            builder.append(inputs.getUnexpectedSequenceThreshold()).append(" reads per 10 million\n");
        }
        return builder.toString();
    }
}

