/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.api.PoolQFilenameInputs;
import org.broadinstitute.rnai.poolq.api.ReadsFileType;
import org.broadinstitute.rnai.poolq.gui.PoolQResultsDialog;
import org.broadinstitute.rnai.poolq.gui.PoolQRunCancelledListener;
import org.broadinstitute.rnai.poolq.gui.ProgressIndicatorDialog;
import org.broadinstitute.rnai.poolq.gui.SwingUtils;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserListener;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserPanelFactory;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserPanelType;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileSelectionPanel;
import org.broadinstitute.rnai.poolq.impl.PoolQImpl;
import org.broadinstitute.rnai.poolq.impl.PoolQInterruptedException;
import org.broadinstitute.rnai.poolq.impl.TextUtils;

public class PoolQGui {
    private static final int MIN_START_INDEX = 0;
    private static final int MAX_START_INDEX = 30;
    private JFrame mainFrame;
    private final FileChooserPanelFactory fileChooserPanelFactory = new FileChooserPanelFactory();
    private final FileSelectionPanel readsFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.READS);
    private final FileSelectionPanel referenceFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.REFERENCE);
    private final FileSelectionPanel conditionsFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.CONDITIONS);
    private final FileSelectionPanel scoresFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.SCORES);
    private final FileSelectionPanel qualityReportFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.QUALITY);
    private final FileSelectionPanel logNormalizedScoresFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.LOGNORM);
    private final FileSelectionPanel barcodeScoresFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.BARCODE);
    private final FileSelectionPanel unexpectedSequenceFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.UNEXPECTED);
    private final FileSelectionPanel platformReferenceFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.PLATFORM_REFERENCE);
    private int barcodeStartIndex = 0;
    private int hairpinStartIndex = 16;
    private int minHairpinLength = 20;
    private int unexpectedSequenceThreshold = 5000;
    private boolean useExactMatch;
    private boolean includeNonPfReads = false;
    private boolean includeAmbiguous = false;
    private boolean skipShortReads = false;
    private ReadsFileType readsFileType = null;
    private JButton performAnalysisButton;

    public static void main(String[] args) {
        System.err.println("PoolQ version 1.0.1");
        new PoolQGui().createAndDisplayGui();
    }

    private PoolQGui() {
        this.setFileChooserListeners();
    }

    private void setFileChooserListeners() {
        FileChooserListener fileChooserListener = new FileChooserListener(){

            @Override
            public void newFileSelected(FileSelectionPanel fileSelectionPanel) {
                PoolQGui.this.performAnalysisButton.setEnabled(PoolQGui.this.areAllFiveRequiredFilesSelected());
                File defaultDirectory = fileSelectionPanel.getDefaultDirectory();
                PoolQGui.this.setFileChoosersDefaultDirectory(defaultDirectory);
            }
        };
        this.readsFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.referenceFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.conditionsFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.scoresFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.qualityReportFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.logNormalizedScoresFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.barcodeScoresFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.unexpectedSequenceFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.platformReferenceFileChooserPanel.setFileChooserListener(fileChooserListener);
    }

    private boolean areAllFiveRequiredFilesSelected() {
        return this.readsFileChooserPanel.isFileSelected() && this.referenceFileChooserPanel.isFileSelected() && this.conditionsFileChooserPanel.isFileSelected() && this.scoresFileChooserPanel.isFileSelected() && this.qualityReportFileChooserPanel.isFileSelected();
    }

    private void setFileChoosersDefaultDirectory(File defaultDirectory) {
        this.readsFileChooserPanel.setDefaultDirectory(defaultDirectory);
        this.referenceFileChooserPanel.setDefaultDirectory(defaultDirectory);
        this.conditionsFileChooserPanel.setDefaultDirectory(defaultDirectory);
        this.scoresFileChooserPanel.setDefaultDirectory(defaultDirectory);
        this.qualityReportFileChooserPanel.setDefaultDirectory(defaultDirectory);
        this.logNormalizedScoresFileChooserPanel.setDefaultDirectory(defaultDirectory);
        this.barcodeScoresFileChooserPanel.setDefaultDirectory(defaultDirectory);
        this.unexpectedSequenceFileChooserPanel.setDefaultDirectory(defaultDirectory);
        this.platformReferenceFileChooserPanel.setDefaultDirectory(defaultDirectory);
    }

    private void createAndDisplayGui() {
        this.mainFrame = new JFrame("PoolQ GUI 1.0.1");
        this.mainFrame.getContentPane().add(this.createMainPanel());
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    private Component createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        mainPanel.add(this.createInputsComponent());
        mainPanel.add(this.createOutputsComponent());
        mainPanel.add(this.createButtonsComponent());
        return mainPanel;
    }

    private Component createInputsComponent() {
        JPanel inputsPanel = new JPanel();
        inputsPanel.setLayout(new BoxLayout(inputsPanel, 1));
        inputsPanel.setBorder(SwingUtils.createDefaultTitledBorder("Inputs"));
        inputsPanel.add(this.readsFileChooserPanel);
        inputsPanel.add(this.referenceFileChooserPanel);
        inputsPanel.add(this.conditionsFileChooserPanel);
        inputsPanel.add(this.platformReferenceFileChooserPanel);
        inputsPanel.add(Box.createVerticalStrut(3));
        inputsPanel.add(this.createUseExactMatchButtonPanel());
        inputsPanel.add(Box.createVerticalStrut(3));
        inputsPanel.add(this.createBarcodeStartIndexPanel());
        inputsPanel.add(Box.createVerticalStrut(3));
        inputsPanel.add(this.createHairpinStartIndexPanel());
        inputsPanel.add(Box.createVerticalStrut(3));
        inputsPanel.add(this.createMinHairpinLengthPanel());
        inputsPanel.add(Box.createVerticalStrut(3));
        inputsPanel.add(this.createReadsFileTypeButtonPanel());
        inputsPanel.add(this.createIncludeNonPfReadsButtonPanel());
        inputsPanel.add(this.createIncludeAmbiguousButtonPanel());
        inputsPanel.add(this.createSkipShortReadsButtonPanel());
        return inputsPanel;
    }

    private JPanel createBarcodeStartIndexPanel() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JSpinner spinner = (JSpinner)event.getSource();
                PoolQGui.this.barcodeStartIndex = (Integer)spinner.getValue();
            }
        };
        return this.createSpinnerInputPanel(this.barcodeStartIndex, listener, "Barcode start index:");
    }

    private JPanel createHairpinStartIndexPanel() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JSpinner spinner = (JSpinner)event.getSource();
                PoolQGui.this.hairpinStartIndex = (Integer)spinner.getValue();
            }
        };
        return this.createSpinnerInputPanel(this.hairpinStartIndex, listener, "Hairpin start index:");
    }

    private JPanel createMinHairpinLengthPanel() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JSpinner spinner = (JSpinner)event.getSource();
                PoolQGui.this.minHairpinLength = (Integer)spinner.getValue();
            }
        };
        return this.createSpinnerInputPanel(this.minHairpinLength, listener, "Minimum hairpin length");
    }

    private JPanel createUnexpectedSequenceThresholdPanel() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JSpinner spinner = (JSpinner)event.getSource();
                PoolQGui.this.unexpectedSequenceThreshold = (Integer)spinner.getValue();
            }
        };
        return this.createSpinnerInputPanel(this.unexpectedSequenceThreshold, listener, "Unexpected sequence threshold (per 10 million)", 0, 10000000);
    }

    private JPanel createSpinnerInputPanel(int startValue, ChangeListener listener, String labelText) {
        return this.createSpinnerInputPanel(startValue, listener, labelText, 0, 30);
    }

    private JPanel createSpinnerInputPanel(int startValue, ChangeListener listener, String labelText, int minStartIndex, int maxStartIndex) {
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(startValue, minStartIndex, maxStartIndex, 1);
        JSpinner spinner = new JSpinner(spinnerModel);
        spinner.addChangeListener(listener);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(labelText), "West");
        panel.add((Component)spinner, "East");
        panel.setMaximumSize(new Dimension(panel.getMaximumSize().width, panel.getPreferredSize().height));
        return panel;
    }

    private JPanel createIncludeNonPfReadsButtonPanel() {
        return this.createYesNoButtonPanel("Include non-PF reads?", new Setter<Boolean>(){

            @Override
            public void set(Boolean newValue) {
                PoolQGui.this.includeNonPfReads = newValue;
            }
        });
    }

    private JPanel createIncludeAmbiguousButtonPanel() {
        return this.createYesNoButtonPanel("Include ambiguous matches?", new Setter<Boolean>(){

            @Override
            public void set(Boolean newValue) {
                PoolQGui.this.includeAmbiguous = newValue;
            }
        });
    }

    private JPanel createSkipShortReadsButtonPanel() {
        return this.createYesNoButtonPanel("Skip short reads?", new Setter<Boolean>(){

            @Override
            public void set(Boolean newValue) {
                PoolQGui.this.skipShortReads = newValue;
            }
        });
    }

    private JPanel createUseExactMatchButtonPanel() {
        return this.createYesNoButtonPanel("Require exact match?", new Setter<Boolean>(){

            @Override
            public void set(Boolean newValue) {
                PoolQGui.this.useExactMatch = newValue;
            }
        });
    }

    private JPanel createReadsFileTypeButtonPanel() {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        ButtonGroup group = new ButtonGroup();
        for (final ReadsFileType fileType : ReadsFileType.values()) {
            JRadioButton button = new JRadioButton(fileType.toString());
            button.setEnabled(true);
            button.setSelected(fileType == ReadsFileType.AUTO);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PoolQGui.this.readsFileType = fileType;
                }
            });
            innerPanel.add(button);
            group.add(button);
        }
        return this.createButtonOuterPanel("Reads file type:", innerPanel);
    }

    private JPanel createYesNoButtonPanel(String label, final Setter<Boolean> setter) {
        JRadioButton noButton = new JRadioButton("No");
        noButton.setEnabled(true);
        noButton.setSelected(true);
        noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                setter.set(false);
            }
        });
        JRadioButton yesButton = new JRadioButton("Yes");
        yesButton.setEnabled(true);
        yesButton.setSelected(false);
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                setter.set(true);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(yesButton);
        buttonGroup.add(noButton);
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        innerPanel.add(yesButton);
        innerPanel.add(noButton);
        return this.createButtonOuterPanel(label, innerPanel);
    }

    private JPanel createButtonOuterPanel(String label, JPanel innerPanel) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(label), "West");
        panel.add((Component)innerPanel, "East");
        panel.setMaximumSize(new Dimension(panel.getMaximumSize().width, panel.getPreferredSize().height));
        return panel;
    }

    private Component createOutputsComponent() {
        JPanel outputsPanel = new JPanel();
        outputsPanel.setLayout(new BoxLayout(outputsPanel, 1));
        outputsPanel.setBorder(SwingUtils.createDefaultTitledBorder("Outputs"));
        outputsPanel.add(this.scoresFileChooserPanel);
        outputsPanel.add(this.qualityReportFileChooserPanel);
        outputsPanel.add(this.logNormalizedScoresFileChooserPanel);
        outputsPanel.add(this.barcodeScoresFileChooserPanel);
        outputsPanel.add(this.unexpectedSequenceFileChooserPanel);
        outputsPanel.add(this.createUnexpectedSequenceThresholdPanel());
        outputsPanel.add(Box.createVerticalStrut(3));
        return outputsPanel;
    }

    private Component createButtonsComponent() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        buttonsPanel.add(Box.createHorizontalGlue());
        this.performAnalysisButton = new JButton("Perform Analysis");
        this.performAnalysisButton.setEnabled(false);
        this.performAnalysisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PoolQGui.this.userConfirmsPerformAnalysis()) {
                    PoolQRunnable poolQRunnable = new PoolQRunnable();
                    poolQRunnable.start();
                }
            }
        });
        buttonsPanel.add(this.performAnalysisButton);
        return buttonsPanel;
    }

    private boolean userConfirmsPerformAnalysis() {
        boolean unexpectedSequenceFileExists;
        File scoresFile = new File(this.scoresFileChooserPanel.getSelectedFileName());
        boolean scoresFileExists = scoresFile.exists();
        File qualityFile = new File(this.qualityReportFileChooserPanel.getSelectedFileName());
        boolean qualityFileExists = qualityFile.exists();
        String logNormalizedScoresFileName = this.logNormalizedScoresFileChooserPanel.getSelectedFileName();
        File logNormalizedScoresFile = logNormalizedScoresFileName == null ? null : new File(logNormalizedScoresFileName);
        boolean logNormalizedScoresFileExists = logNormalizedScoresFile != null && logNormalizedScoresFile.exists();
        String unexpectedSequenceFileName = this.unexpectedSequenceFileChooserPanel.getSelectedFileName();
        File unexpectedSequenceFile = unexpectedSequenceFileName == null ? null : new File(unexpectedSequenceFileName);
        boolean bl = unexpectedSequenceFileExists = unexpectedSequenceFile != null && unexpectedSequenceFile.exists();
        if (!(scoresFileExists || qualityFileExists || logNormalizedScoresFileExists || unexpectedSequenceFileExists)) {
            return true;
        }
        String message = this.buildConfirmOverwriteMessage(scoresFileExists, qualityFileExists, logNormalizedScoresFileExists, unexpectedSequenceFileExists);
        int confirmation = JOptionPane.showConfirmDialog(this.mainFrame, message, "Confirm Overwrite Existing Files", 2, 2);
        return confirmation != 2;
    }

    String buildConfirmOverwriteMessage(boolean scoresFileExists, boolean qualityFileExists, boolean logNormalizedScoresFileExists, boolean unexpectedSequenceFileExists) {
        ArrayList<String> elements = new ArrayList<String>();
        if (scoresFileExists) {
            elements.add("scores file");
        }
        if (qualityFileExists) {
            elements.add("quality file");
        }
        if (logNormalizedScoresFileExists) {
            elements.add("log normalized scores file");
        }
        if (unexpectedSequenceFileExists) {
            elements.add("unexpected sequence report file");
        }
        if (!elements.isEmpty()) {
            StringBuilder sb = new StringBuilder("The ").append(TextUtils.buildEnglishLanguageList(elements)).append(" that you specified already exist");
            if (elements.size() == 1) {
                sb.append('s');
            }
            sb.append(". Do you want to overwrite?");
            return sb.toString();
        }
        return null;
    }

    private static interface Setter<T> {
        public void set(T var1);
    }

    private class PoolQRunnable
    extends Thread {
        private PoolQRunCancelledListener poolQRunCancelledListener = new PoolQRunCancelledListener(){

            @Override
            public void poolQRunCancelled() {
                PoolQRunnable.this.interrupt();
            }
        };
        private ProgressIndicatorDialog progressIndicatorDialog = new ProgressIndicatorDialog(PoolQGui.access$1400(PoolQGui.this), this.poolQRunCancelledListener);

        private PoolQRunnable() {
        }

        @Override
        public void run() {
            this.showProgressIndicator();
            PoolQFilenameInputs poolQDataInputs = new PoolQFilenameInputs(){

                @Override
                public String getReadsFilename() {
                    return PoolQGui.this.readsFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getReferenceFilename() {
                    return PoolQGui.this.referenceFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getConditionsFilename() {
                    return PoolQGui.this.conditionsFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getScoresFilename() {
                    return PoolQGui.this.scoresFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getQualityFilename() {
                    return PoolQGui.this.qualityReportFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getLogNormalizedScoresFilename() {
                    return PoolQGui.this.logNormalizedScoresFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getBarcodeScoresFilename() {
                    return PoolQGui.this.barcodeScoresFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getPlatformReferenceFilename() {
                    return PoolQGui.this.platformReferenceFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getUnexpectedSequenceFilename() {
                    return PoolQGui.this.unexpectedSequenceFileChooserPanel.getSelectedFileName();
                }

                @Override
                public int getUnexpectedSequenceThreshold() {
                    return PoolQGui.this.unexpectedSequenceThreshold;
                }

                @Override
                public boolean requireExactMatch() {
                    return PoolQGui.this.useExactMatch;
                }

                @Override
                public boolean includeNonPfReads() {
                    return PoolQGui.this.includeNonPfReads;
                }

                @Override
                public int getBarcodeStartIndex() {
                    return PoolQGui.this.barcodeStartIndex;
                }

                @Override
                public int getHairpinStartIndex() {
                    return PoolQGui.this.hairpinStartIndex;
                }

                @Override
                public int getMinHairpinLength() {
                    return PoolQGui.this.minHairpinLength;
                }

                @Override
                public boolean includeAmbiguous() {
                    return PoolQGui.this.includeAmbiguous;
                }

                @Override
                public boolean skipShortReads() {
                    return PoolQGui.this.skipShortReads;
                }

                @Override
                public ReadsFileType getReadsFileType() {
                    return PoolQGui.this.readsFileType;
                }
            };
            try {
                new PoolQImpl().runPoolQ(poolQDataInputs);
                this.hideProgressIndicator();
                this.showSuccessDialog();
            }
            catch (PoolQInterruptedException e) {
                this.hideProgressIndicator();
            }
            catch (PoolQException e) {
                this.hideProgressIndicator();
                this.showErrorDialog(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.hideProgressIndicator();
                this.showUnexpectedErrorDialog(e);
            }
        }

        private void showProgressIndicator() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PoolQRunnable.this.progressIndicatorDialog.setVisible(true);
                }
            });
        }

        private void hideProgressIndicator() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PoolQRunnable.this.progressIndicatorDialog.dispose();
                }
            });
        }

        private void showSuccessDialog() {
            PoolQResultsDialog poolQResultsDialog = new PoolQResultsDialog(PoolQGui.this.mainFrame, PoolQGui.this.scoresFileChooserPanel.getSelectedFileName(), PoolQGui.this.qualityReportFileChooserPanel.getSelectedFileName());
            poolQResultsDialog.setVisible(true);
        }

        private void showErrorDialog(Exception e) {
            this.showErrorDialog("PoolQ encountered the following error when performing the analysis:", e);
        }

        private void showUnexpectedErrorDialog(Exception e) {
            this.showErrorDialog("The following unexpected error occurred:", e);
        }

        private void showErrorDialog(String errorPrefix, Exception e) {
            String message = errorPrefix + "\n\n" + e.getMessage();
            JOptionPane.showMessageDialog(PoolQGui.this.mainFrame, message, "PoolQ Error", 0);
        }
    }
}

