/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.broadinstitute.rnai.poolq.gui.SwingUtils;

class PoolQResultsDialog
extends JDialog {
    private final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
    private final String scoresFilename;
    private final String qualityReportFilename;

    PoolQResultsDialog(JFrame parent, String scoresFilename, String qualityReportFilename) {
        super(parent);
        this.scoresFilename = scoresFilename;
        this.qualityReportFilename = qualityReportFilename;
        this.setModal(true);
        this.setTitle("PoolQ Results");
        this.getContentPane().add(this.createMainPanel(parent));
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private Component createMainPanel(JFrame parent) {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        JLabel label1 = new JLabel("PoolQ successfully finished performing the analysis.");
        label1.setAlignmentX(0.0f);
        mainPanel.add(label1);
        JLabel label2 = new JLabel("The scores file and quality report have been written to the locations you specified.");
        mainPanel.add(label2);
        label2.setAlignmentX(0.0f);
        mainPanel.add(Box.createVerticalStrut(5));
        JButton openScoresFileButton = new JButton("Open Scores File");
        openScoresFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PoolQResultsDialog.this.respondToOpenFileAction(mainPanel, PoolQResultsDialog.this.scoresFilename);
            }
        });
        openScoresFileButton.setAlignmentX(0.0f);
        mainPanel.add(openScoresFileButton);
        mainPanel.add(Box.createVerticalStrut(5));
        JButton openQualityReportButton = new JButton("Open Quality Report");
        openQualityReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PoolQResultsDialog.this.respondToOpenFileAction(mainPanel, PoolQResultsDialog.this.qualityReportFilename);
            }
        });
        openQualityReportButton.setAlignmentX(0.0f);
        mainPanel.add(openQualityReportButton);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(this.createNavigationButtonsComponent());
        return mainPanel;
    }

    private Component createNavigationButtonsComponent() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton closeResultsWindowButton = new JButton("Close Results Window");
        closeResultsWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PoolQResultsDialog.this.dispose();
            }
        });
        buttonsPanel.add(closeResultsWindowButton);
        buttonsPanel.add(Box.createHorizontalStrut(5));
        JButton quitPoolQGuiButton = new JButton("Quit PoolQ GUI");
        quitPoolQGuiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        buttonsPanel.add(quitPoolQGuiButton);
        buttonsPanel.setAlignmentX(0.0f);
        return buttonsPanel;
    }

    private void respondToOpenFileAction(JPanel mainPanel, String filename) {
        if (this.canOpenFileWithDefaultApplication()) {
            try {
                this.desktop.open(new File(filename));
            }
            catch (IOException e) {
                String message = "Unexpected error when trying to open file: " + e.getMessage();
                JOptionPane.showMessageDialog(mainPanel, message);
            }
        } else {
            String message = "Sorry, but your desktop configuration doesn't support opening files from within a Java application. Try Gnome.";
            JOptionPane.showMessageDialog(mainPanel, "Sorry, but your desktop configuration doesn't support opening files from within a Java application. Try Gnome.");
        }
    }

    private boolean canOpenFileWithDefaultApplication() {
        return this.desktop != null && this.desktop.isSupported(Desktop.Action.OPEN);
    }
}

