/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserListener;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserPanelType;

public class FileSelectionPanel
extends JPanel {
    private static final int TEXT_FIELD_PREFERRED_SIZE = 400;
    private final FileChooserPanelType fileChooserPanelType;
    private JTextField textField;
    private File defaultDirectory;
    private FileChooserListener fileChooserListener;

    FileSelectionPanel(JLabel label, FileChooserPanelType fileChooserPanelType) {
        this.fileChooserPanelType = fileChooserPanelType;
        this.setLayout(new BorderLayout());
        this.add((Component)label, "West");
        this.add((Component)this.buildTextPanel(), "Center");
        this.add((Component)this.buildBrowseButton(), "East");
        this.preventVerticalExpansion();
        this.defaultDirectory = new File(System.getProperty("user.dir"));
    }

    public boolean isFileSelected() {
        return this.getSelectedFileName() != null && !this.getSelectedFileName().equals("");
    }

    public String getSelectedFileName() {
        String selectedFileName = this.textField.getText();
        if (selectedFileName.trim().equals("")) {
            return null;
        }
        return selectedFileName;
    }

    public File getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void setDefaultDirectory(File defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
        if (!this.isFileSelected()) {
            this.textField.setText(new File(defaultDirectory, this.fileChooserPanelType.getDefaultFileName()).getAbsolutePath());
            if (this.fileChooserListener != null) {
                this.fileChooserListener.newFileSelected(this);
            }
        }
    }

    public void setFileChooserListener(FileChooserListener fileChooserListener) {
        if (this.fileChooserListener != null) {
            throw new UnsupportedOperationException();
        }
        this.fileChooserListener = fileChooserListener;
    }

    private JPanel buildTextPanel() {
        this.textField = new JTextField();
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        textPanel.setPreferredSize(new Dimension(400, this.textField.getPreferredSize().height));
        textPanel.add((Component)this.textField, "Center");
        return textPanel;
    }

    private JButton buildBrowseButton() {
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(FileSelectionPanel.this.defaultDirectory);
                fileChooser.setDialogTitle(FileSelectionPanel.this.fileChooserPanelType.getDialogTitle());
                fileChooser.setFileSelectionMode(0);
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setSelectedFile(new File(FileSelectionPanel.this.fileChooserPanelType.getDefaultFileName()));
                int fileChooserResult = fileChooser.showOpenDialog(FileSelectionPanel.this);
                if (fileChooserResult == 0) {
                    fileChooser.getSelectedFile();
                    File selectedFile = fileChooser.getSelectedFile();
                    FileSelectionPanel.this.defaultDirectory = selectedFile.getParentFile();
                    FileSelectionPanel.this.textField.setText(selectedFile.getAbsolutePath());
                    if (FileSelectionPanel.this.fileChooserListener != null) {
                        FileSelectionPanel.this.fileChooserListener.newFileSelected(FileSelectionPanel.this);
                    }
                }
            }
        });
        return browseButton;
    }

    private void preventVerticalExpansion() {
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, this.getPreferredSize().height));
    }
}

