/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl;

import gnu.trove.map.TObjectIntMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.rnai.poolq.api.QualityReportData;

public class QualityReportDataImpl
implements QualityReportData {
    private final int barcodeLength;
    private final Map<String, String> barcodeToConditionMap;
    private final TObjectIntMap<String> barcodeToReadCountMap;
    private final TObjectIntMap<String> barcodeToMatchingHairpinReadCountMap;
    private final Map<String, Set<String>> truncatedHairpinToCollidingHairpinIdsMap;
    private final long numberOfReads;
    private final long numberOfMatchingReads;
    private final long numberOfSingleBaseMismatchReads;
    private final long numberOfSkippedShortReads;

    public QualityReportDataImpl(int barcodeLength, Map<String, String> barcodeToConditionMap, TObjectIntMap<String> barcodeToReadCountMap, TObjectIntMap<String> barcodeToMatchingHairpinReadCountMap, Map<String, Set<String>> truncatedHairpinToCollidingHairpinIdsMap, long numberOfReads, long numberOfMatchingReads, long numberOfSingleBaseMismatchReads, long numberOfSkippedShortReads) {
        this.barcodeLength = barcodeLength;
        this.barcodeToConditionMap = barcodeToConditionMap;
        this.barcodeToReadCountMap = barcodeToReadCountMap;
        this.barcodeToMatchingHairpinReadCountMap = barcodeToMatchingHairpinReadCountMap;
        this.truncatedHairpinToCollidingHairpinIdsMap = truncatedHairpinToCollidingHairpinIdsMap;
        this.numberOfReads = numberOfReads;
        this.numberOfMatchingReads = numberOfMatchingReads;
        this.numberOfSingleBaseMismatchReads = numberOfSingleBaseMismatchReads;
        this.numberOfSkippedShortReads = numberOfSkippedShortReads;
    }

    @Override
    public int getBarcodeLength() {
        return this.barcodeLength;
    }

    @Override
    public Map<String, String> getBarcodeToConditionMap() {
        return this.barcodeToConditionMap;
    }

    @Override
    public Integer getReadCountForBarcode(String barcode) {
        return this.barcodeToReadCountMap.get(barcode);
    }

    @Override
    public Set<String> getBarcodesWithNonZeroReadCounts() {
        return new TreeSet<String>(this.barcodeToReadCountMap.keySet());
    }

    @Override
    public Integer getMatchingHairpinReadCountForBarcode(String barcode) {
        return this.barcodeToMatchingHairpinReadCountMap.get(barcode);
    }

    @Override
    public Map<String, Set<String>> getTruncatedHairpinToCollidingHairpinIdsMap() {
        return this.truncatedHairpinToCollidingHairpinIdsMap;
    }

    @Override
    public long getNumberOfReads() {
        return this.numberOfReads;
    }

    @Override
    public long getNumberOfMatchingReads() {
        return this.numberOfMatchingReads;
    }

    @Override
    public long getNumberOfSingleBaseMismatchReads() {
        return this.numberOfSingleBaseMismatchReads;
    }

    @Override
    public long getNumberOfSkippedShortReads() {
        return this.numberOfSkippedShortReads;
    }
}

