/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.PrimaryIndex;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.broadinstitute.rnai.poolq.impl.data.HairpinReferenceDatabase;
import org.broadinstitute.rnai.poolq.impl.data.HairpinVariantToHairpins;
import org.broadinstitute.rnai.poolq.impl.data.ReadProcessor;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabase;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HairpinTempDatabase
extends TempDatabase
implements HairpinReferenceDatabase {
    private static final Logger logger = LoggerFactory.getLogger(HairpinTempDatabase.class);
    private static final char[] N_BASES = new char[]{'A', 'C', 'G', 'T', 'N'};
    private final ReadProcessor readProcessor;
    private PrimaryIndex<String, HairpinVariantToHairpins> hairpinVariantIndex;

    public HairpinTempDatabase(ReadProcessor readProcessor) {
        this.readProcessor = readProcessor;
        this.hairpinVariantIndex = this.getPrimaryIndex(String.class, HairpinVariantToHairpins.class);
    }

    @Override
    public void buildHairpinVariantDatabase(Set<String> originalHairpins, boolean includeVariants) {
        logger.info("Building hairpin variant database");
        try {
            this.populateHairpinVariantDatabaseWithOriginalHairpins(originalHairpins);
            if (includeVariants) {
                this.populateHairpinVariantDatabaseWithVariants(originalHairpins);
            }
        }
        catch (Exception e) {
            throw new TempDatabaseException(e);
        }
    }

    @Override
    public List<String> getHairpinsForHairpinVariant(String hairpinVariant) {
        try {
            HairpinVariantToHairpins hairpinVariantToHairpins = this.hairpinVariantIndex.get(hairpinVariant);
            if (hairpinVariantToHairpins == null) {
                return Collections.emptyList();
            }
            List<String> hairpins = hairpinVariantToHairpins.getHairpins();
            if (hairpins.contains(hairpinVariant)) {
                return Collections.singletonList(hairpinVariant);
            }
            return hairpins;
        }
        catch (DatabaseException e) {
            throw new TempDatabaseException(e);
        }
    }

    private void populateHairpinVariantDatabaseWithOriginalHairpins(Set<String> originalHairpins) throws DatabaseException {
        for (String hairpin : originalHairpins) {
            String truncatedHairpin = this.readProcessor.truncateHairpin(hairpin);
            this.addHairpinForVariant(truncatedHairpin, hairpin);
        }
    }

    private void populateHairpinVariantDatabaseWithVariants(Set<String> originalHairpins) throws DatabaseException {
        for (String hairpin : originalHairpins) {
            String truncatedHairpin = this.readProcessor.truncateHairpin(hairpin);
            for (String hairpinVariant : this.buildHairpinVariants(truncatedHairpin)) {
                this.addHairpinForVariant(hairpinVariant, hairpin);
            }
        }
    }

    private void addHairpinForVariant(String hairpinVariant, String hairpin) {
        List<String> hairpins;
        HairpinVariantToHairpins hairpinVariantToHairpins = this.hairpinVariantIndex.get(hairpinVariant);
        if (hairpinVariantToHairpins == null) {
            hairpins = new ArrayList<String>();
            hairpinVariantToHairpins = new HairpinVariantToHairpins(hairpinVariant, hairpins);
        } else {
            hairpins = hairpinVariantToHairpins.getHairpins();
        }
        hairpins.add(hairpin);
        this.hairpinVariantIndex.putNoReturn(hairpinVariantToHairpins);
    }

    private Set<String> buildHairpinVariants(String hairpin) {
        THashSet<String> hairpinVariants = new THashSet<String>();
        for (int i = 0; i < hairpin.length(); ++i) {
            for (char base : N_BASES) {
                char[] hairpinAsCharArray = hairpin.toCharArray();
                if (base == hairpinAsCharArray[i]) continue;
                hairpinAsCharArray[i] = base;
                String hairpinVariant = new String(hairpinAsCharArray);
                hairpinVariants.add(hairpinVariant);
            }
        }
        return hairpinVariants;
    }
}

