/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.util.regex.Pattern;
import org.broadinstitute.rnai.poolq.api.ReadsFileType;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileParserException;

class ReadsFileInfo {
    private static final Pattern FILENAME_SPLIT = Pattern.compile("\\.");
    private final ReadsFileType readsFileType;
    private final boolean isGzFile;

    public static ReadsFileInfo forName(String fileName) {
        return new ReadsFileInfo(fileName);
    }

    ReadsFileInfo(String fileName) {
        String extension;
        String[] parts = FILENAME_SPLIT.split(fileName);
        if (parts.length < 2) {
            throw new ReadsFileParserException("Unable to determine file type for reads file " + fileName);
        }
        this.isGzFile = parts[parts.length - 1].equalsIgnoreCase("gz");
        if (this.isGzFile) {
            if (parts.length < 3) {
                throw new ReadsFileParserException("Unable to determine file type for reads file " + fileName);
            }
            extension = parts[parts.length - 2].toLowerCase();
        } else {
            extension = parts[parts.length - 1].toLowerCase();
        }
        if (extension.equals("fastq") || extension.equals("txt")) {
            this.readsFileType = ReadsFileType.FASTQ;
        } else if (extension.equals("bam")) {
            this.readsFileType = ReadsFileType.BAM;
        } else if (extension.equals("raw")) {
            this.readsFileType = ReadsFileType.RAW;
        } else {
            throw new ReadsFileParserException("Unsupported reads file type " + extension);
        }
    }

    public ReadsFileType getReadsFileType() {
        return this.readsFileType;
    }

    public boolean isGzFile() {
        return this.isGzFile;
    }
}

