/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.rnai.poolq.impl.fileparser.ColumnFileParser;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReferenceFileParserException;

public class ReferenceFileParser {
    private static final Pattern HAIRPIN_PATTERN = Pattern.compile("^[ACGT]+$");
    private int minHairpinLength;

    public ReferenceFileParser(int minHairpinLength) {
        this.minHairpinLength = minHairpinLength;
    }

    public Map<String, List<String>> parseHairpinToHairpinIdsMapFromInputStream(InputStream inputStream) throws IOException, ReferenceFileParserException {
        HashMap<String, String> hairpinIdToHairpinMap = new HashMap<String, String>();
        LinkedHashMap<String, List<String>> hairpinToHairpinIdsMap = new LinkedHashMap<String, List<String>>();
        int lineNumber = 0;
        for (String[] cells : new ColumnFileParser(inputStream)) {
            ++lineNumber;
            if (cells.length == 0) continue;
            if (cells.length != 2) {
                throw new ReferenceFileParserException.IncorrectNumberOfColumnsException("Line does not contain two columns", lineNumber, cells);
            }
            String hairpin = cells[0].trim();
            this.checkHairpinIsValid(hairpin, lineNumber, cells);
            String hairpinId = cells[1].trim();
            this.checkHairpinIdIsValid(hairpinId, hairpin, hairpinIdToHairpinMap, lineNumber, cells);
            ArrayList<String> hairpinIds = (ArrayList<String>)hairpinToHairpinIdsMap.get(hairpin);
            if (hairpinIds == null) {
                hairpinIds = new ArrayList<String>();
                hairpinToHairpinIdsMap.put(hairpin, hairpinIds);
            }
            hairpinIds.add(hairpinId);
        }
        if (hairpinToHairpinIdsMap.isEmpty()) {
            throw new ReferenceFileParserException.EmptyReferenceFileException("Reference file is empty", lineNumber);
        }
        return hairpinToHairpinIdsMap;
    }

    private void checkHairpinIsValid(String hairpin, int lineNumber, String[] cells) {
        if (!this.hairpinMatchesHairpinPattern(hairpin)) {
            throw new ReferenceFileParserException.BadHairpinException("Hairpin '" + hairpin + "' is not a valid hairpin", lineNumber, cells);
        }
        if (hairpin.length() < this.minHairpinLength) {
            throw new ReferenceFileParserException.BadHairpinException("Hairpin '" + hairpin + "' is not a valid hairpin", lineNumber, cells);
        }
    }

    private boolean hairpinMatchesHairpinPattern(String hairpin) {
        Matcher matcher = HAIRPIN_PATTERN.matcher(hairpin);
        return matcher.matches();
    }

    private void checkHairpinIdIsValid(String hairpinId, String hairpin, Map<String, String> hairpinIdToHairpinMap, int lineNumber, String[] cells) {
        if (hairpinId == null || hairpinId.isEmpty()) {
            throw new ReferenceFileParserException.BadHairpinIdException("Hairpin " + hairpin + " is mapped to an invalid hairpin ID", lineNumber, cells);
        }
        String existingHairpin = hairpinIdToHairpinMap.get(hairpinId);
        if (hairpinIdToHairpinMap.containsKey(hairpinId) && !existingHairpin.equals(hairpin)) {
            throw new ReferenceFileParserException.DuplicateHairpinIdMappingException("Hairpin " + hairpinId + " is already mapped to hairpin ID " + existingHairpin, lineNumber, cells);
        }
        hairpinIdToHairpinMap.put(hairpinId, hairpin);
    }
}

