/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.PrintWriter;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.impl.filewriter.ScoresFileWriter;

public class GctScoresFileWriter
extends ScoresFileWriter {
    public static final String GCT_VERSION_STRING = "#1.2";
    public static final String GCT_EXTRA_COLUMN_HEADER = "Description";

    @Override
    protected void printHeaders(PoolQScores poolQScores, PrintWriter printWriter) {
        printWriter.append("Hairpin Sequence");
        printWriter.print("\t");
        printWriter.print(GCT_EXTRA_COLUMN_HEADER);
        for (String condition : poolQScores.getConditions()) {
            printWriter.append('\t').append(condition);
        }
        printWriter.append('\n');
    }

    @Override
    protected void printPreamble(PoolQScores poolQScores, PrintWriter printWriter) {
        printWriter.println(GCT_VERSION_STRING);
        printWriter.print(poolQScores.getHairpins().size());
        printWriter.print("\t");
        printWriter.print(poolQScores.getConditions().size());
        printWriter.println();
    }
}

