/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.rnai.poolq.api.QualityReportData;
import org.broadinstitute.rnai.poolq.impl.filewriter.LogNormalizer;

public class QualityReportFileWriter {
    public static final String TOTAL_NUMBER_OF_READS_PREFIX = "Total reads:\t\t\t";
    public static final String TOTAL_NUMBER_OF_MATCHING_READS_PREFIX = "Matching reads:\t\t\t";
    public static final String TOTAL_NUMBER_OF_SINGLE_BASE_MISMATCH_READS_PREFIX = "1-Base mismatch reads:\t\t\t";
    public static final String PERCENTAGE_MATCHING_READS_WITH_BARCODES_PREFIX = "Overall Match: (HP+BC)/total reads:\t\t\t";
    public static final String AVERAGE_NON_SAMPLE_BARCODE_COUNTS_PREFIX = "Avg. counts for non-sample barcodes:\t\t\t";
    public static final String NORMALIZED_AVERAGE_NON_SAMPLE_BARCODE_COUNTS_PREFIX = "Normalized avg. non-sample barcodes:\t\t\t";
    public static final String BARCODES_WITH_ASSOCIATED_CONDITIONS_HEADER = "Read counts for barcodes with associated conditions:";
    public static final String BARCODES_WITH_ASSOCIATED_CONDITIONS_COLS = "Barcode\tCondition\tMatched (HP+BC)\tMatched BC\t%Match\tNormalized Match";
    public static final String BARCODES_WITHOUT_ASSOCIATED_CONDITIONS_HEADER = "Read counts for barcodes without associated conditions:";
    public static final String HAIRPINS_MATCHING_MULTIPLE_HAIRPIN_IDS_HEADER = "Hairpins matching multiple hairpins (either due to duplication in the reference file, or to hairpin truncation in the reads):";
    public static final String PCT_FORMAT = "%1$.2f";
    private final LogNormalizer normalizer = new LogNormalizer();

    public void writeQualityReportFile(QualityReportData qualityReportData, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.writeReadCounts(qualityReportData, printWriter);
        printWriter.println();
        this.writeDerivedMatchStatistics(qualityReportData, printWriter);
        printWriter.println();
        this.writeCountsForBarcodesWithConditions(qualityReportData, printWriter);
        printWriter.println();
        this.writeCountsForBarcodesWithoutConditions(qualityReportData, printWriter);
        if (!qualityReportData.getTruncatedHairpinToCollidingHairpinIdsMap().isEmpty()) {
            printWriter.println();
            this.writeHairpinsMatchingMultipleHairpinIds(qualityReportData, printWriter);
        }
        printWriter.close();
    }

    private void writeReadCounts(QualityReportData qualityReportData, PrintWriter printWriter) {
        printWriter.print(TOTAL_NUMBER_OF_READS_PREFIX);
        printWriter.println(qualityReportData.getNumberOfReads());
        printWriter.print(TOTAL_NUMBER_OF_MATCHING_READS_PREFIX);
        printWriter.println(qualityReportData.getNumberOfMatchingReads());
        printWriter.print(TOTAL_NUMBER_OF_SINGLE_BASE_MISMATCH_READS_PREFIX);
        printWriter.println(qualityReportData.getNumberOfSingleBaseMismatchReads());
    }

    private void writeDerivedMatchStatistics(QualityReportData qualityReportData, PrintWriter printWriter) {
        double matchRatio;
        printWriter.print(PERCENTAGE_MATCHING_READS_WITH_BARCODES_PREFIX);
        long totalReads = qualityReportData.getNumberOfReads();
        if (totalReads == 0L) {
            matchRatio = 0.0;
        } else {
            long knownConditionMatchingHairpinReads = 0L;
            for (Map.Entry<String, String> entry : qualityReportData.getBarcodeToConditionMap().entrySet()) {
                String barcode = entry.getKey();
                knownConditionMatchingHairpinReads += (long)qualityReportData.getMatchingHairpinReadCountForBarcode(barcode).intValue();
            }
            matchRatio = (double)knownConditionMatchingHairpinReads / (double)totalReads;
        }
        printWriter.println(this.percentOf(matchRatio));
        printWriter.print(AVERAGE_NON_SAMPLE_BARCODE_COUNTS_PREFIX);
        long nonMappedBarcodes = (long)Math.pow(4.0, qualityReportData.getBarcodeLength()) - (long)qualityReportData.getBarcodeToConditionMap().keySet().size();
        long readsForNonMappedBarcodes = 0L;
        for (String barcode : qualityReportData.getBarcodesWithNonZeroReadCounts()) {
            if (this.barcodeIsMappedToCondition(qualityReportData, barcode)) continue;
            readsForNonMappedBarcodes += (long)qualityReportData.getReadCountForBarcode(barcode).intValue();
        }
        double avg = nonMappedBarcodes == 0L ? 0.0 : (double)readsForNonMappedBarcodes / (double)nonMappedBarcodes;
        printWriter.println(this.decimalOf(avg));
        printWriter.print(NORMALIZED_AVERAGE_NON_SAMPLE_BARCODE_COUNTS_PREFIX);
        printWriter.println(this.decimalOf(this.normalizer.normalize(avg, qualityReportData.getNumberOfReads())));
    }

    private void writeCountsForBarcodesWithConditions(QualityReportData qualityReportData, PrintWriter printWriter) {
        printWriter.println(BARCODES_WITH_ASSOCIATED_CONDITIONS_HEADER);
        printWriter.println(BARCODES_WITH_ASSOCIATED_CONDITIONS_COLS);
        Map<String, String> barcodeToConditionMap = qualityReportData.getBarcodeToConditionMap();
        for (String barcode : barcodeToConditionMap.keySet()) {
            Integer readCount = qualityReportData.getReadCountForBarcode(barcode);
            assert (readCount != null);
            Integer matchingHairpinCount = qualityReportData.getMatchingHairpinReadCountForBarcode(barcode);
            Double matchingRatio = (double)readCount.intValue() == 0.0 ? 0.0 : (double)matchingHairpinCount.intValue() / (double)readCount.intValue();
            printWriter.append(barcode);
            printWriter.append('\t');
            printWriter.append(barcodeToConditionMap.get(barcode));
            printWriter.append('\t');
            printWriter.append(matchingHairpinCount.toString());
            printWriter.append('\t');
            printWriter.append(readCount.toString());
            printWriter.append('\t');
            printWriter.append(this.percentOf(matchingRatio));
            printWriter.append('\t');
            printWriter.append(this.decimalOf(this.normalizer.normalize(matchingHairpinCount, qualityReportData.getNumberOfReads())));
            printWriter.println();
        }
    }

    private void writeCountsForBarcodesWithoutConditions(QualityReportData qualityReportData, PrintWriter printWriter) {
        printWriter.println(BARCODES_WITHOUT_ASSOCIATED_CONDITIONS_HEADER);
        TreeSet<String> detectedBarcodes = new TreeSet<String>(qualityReportData.getBarcodesWithNonZeroReadCounts());
        detectedBarcodes.removeAll(qualityReportData.getBarcodeToConditionMap().keySet());
        for (String barcode : detectedBarcodes) {
            Integer readCount = qualityReportData.getReadCountForBarcode(barcode);
            printWriter.append(barcode);
            printWriter.append('\t');
            printWriter.append(readCount.toString());
            printWriter.println();
        }
    }

    private boolean barcodeIsMappedToCondition(QualityReportData qualityReportData, String barcode) {
        return qualityReportData.getBarcodeToConditionMap().containsKey(barcode);
    }

    private void writeHairpinsMatchingMultipleHairpinIds(QualityReportData qualityReportData, PrintWriter printWriter) {
        printWriter.println(HAIRPINS_MATCHING_MULTIPLE_HAIRPIN_IDS_HEADER);
        Map<String, Set<String>> truncatedHairpinToCollidingHairpinIdsMap = qualityReportData.getTruncatedHairpinToCollidingHairpinIdsMap();
        for (String truncatedHairpin : truncatedHairpinToCollidingHairpinIdsMap.keySet()) {
            printWriter.append(truncatedHairpin);
            printWriter.append(":");
            for (String hairpinId : truncatedHairpinToCollidingHairpinIdsMap.get(truncatedHairpin)) {
                printWriter.append("\t");
                printWriter.append(hairpinId);
            }
            printWriter.println();
        }
    }

    String decimalOf(double value) {
        return new DecimalFormat("0.000").format(value);
    }

    String percentOf(double ratio) {
        DecimalFormat nf = new DecimalFormat("0.00%");
        return nf.format(ratio);
    }
}

