/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.impl.TextUtils;
import org.broadinstitute.rnai.poolq.impl.data.ScoreAggregator;

public class ScoresFileWriter {
    public static final String HAIRPIN_SEQUENCE_COLUMN_HEADER = "Hairpin Sequence";
    public static final String HAIRPIN_ID_COLUMN_HEADER = "Hairpin IDs";

    public void writeScoresFile(PoolQScores poolQScores, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.printPreamble(poolQScores, printWriter);
        this.printHeaders(poolQScores, printWriter);
        this.printBody(poolQScores, printWriter);
        printWriter.close();
    }

    protected void printPreamble(PoolQScores poolQScores, PrintWriter printWriter) {
    }

    protected void printHeaders(PoolQScores poolQScores, PrintWriter printWriter) {
        this.printHairpinAndHairpinIdColumns(printWriter);
        for (String condition : poolQScores.getConditions()) {
            printWriter.append('\t').append(condition);
        }
        printWriter.append('\n');
    }

    protected void printHairpinAndHairpinIdColumns(PrintWriter printWriter) {
        printWriter.append(HAIRPIN_SEQUENCE_COLUMN_HEADER);
        printWriter.append('\t');
        printWriter.append(HAIRPIN_ID_COLUMN_HEADER);
    }

    protected void printBody(PoolQScores poolQScores, PrintWriter printWriter) {
        ScoreAggregator scoreAggregator = new ScoreAggregator(poolQScores.getConditionToBarcodeMap());
        for (String hairpin : poolQScores.getHairpins()) {
            Collection<String> hairpinIds = poolQScores.getHairpinIdsForHairpin(hairpin);
            this.printHairpinAndHairpinIds(printWriter, hairpin, hairpinIds);
            Map<String, Integer> scoresByBarcodeForHairpin = poolQScores.getScoresByBarcodeForHairpin(hairpin);
            String scores = TextUtils.join(scoreAggregator.getScoresListByCondition(scoresByBarcodeForHairpin, poolQScores.getConditions()), '\t');
            if (!scores.isEmpty()) {
                printWriter.append('\t');
                printWriter.append(scores);
            }
            printWriter.append('\n');
        }
    }

    protected void printHairpinAndHairpinIds(PrintWriter printWriter, String hairpin, Collection<String> hairpinIds) {
        printWriter.append(hairpin);
        printWriter.append('\t');
        printWriter.append(TextUtils.join(hairpinIds, ","));
    }
}

