/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.HairpinScore;
import org.broadinstitute.rnai.poolq.api.UnexpectedSequenceReportData;
import org.broadinstitute.rnai.poolq.impl.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnexpectedSequenceFileWriter {
    private static final double TEN_MILLION_POINT_OH = 1.0E7;
    private static final Logger logger = LoggerFactory.getLogger(UnexpectedSequenceFileWriter.class);

    public void writeUnexpectedSequenceFile(UnexpectedSequenceReportData unexpectedSequenceReportData, int unexpectedSequenceThreshold, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.writeUnexpectedSequenceHeader(unexpectedSequenceReportData, unexpectedSequenceThreshold, printWriter);
        this.writeUnexpectedSequences(unexpectedSequenceReportData, unexpectedSequenceThreshold, printWriter);
        printWriter.append('\n');
        this.writeUnexpectedBarcodeCountHeader(unexpectedSequenceReportData, unexpectedSequenceThreshold, printWriter);
        this.writeUnexpectedBarcodeCounts(unexpectedSequenceReportData, unexpectedSequenceThreshold, printWriter);
        printWriter.close();
    }

    protected void writeUnexpectedSequenceHeader(UnexpectedSequenceReportData unexpectedSequenceReportData, int unexpectedSequenceThreshold, PrintWriter printWriter) {
        printWriter.append("Sequence\tTotal\t");
        for (String barcode : unexpectedSequenceReportData.getBarcodesMappedToConditions()) {
            printWriter.append(barcode);
            printWriter.append('\t');
        }
        printWriter.append("Hairpin IDs");
        printWriter.append('\n');
    }

    protected void writeUnexpectedSequences(UnexpectedSequenceReportData unexpectedSequenceReportData, int unexpectedSequenceThreshold, PrintWriter printWriter) {
        int unexpectedHairpinsProcessed = 0;
        try {
            for (HairpinScore hairpinScore : unexpectedSequenceReportData.getUnexpectedHairpins()) {
                int totalScoreForHairpin = 0;
                StringBuilder sb = new StringBuilder();
                Map<String, Integer> readsByBarcode = hairpinScore.getReadCountsByBarcode();
                for (String barcode : unexpectedSequenceReportData.getBarcodesMappedToConditions()) {
                    Integer score = readsByBarcode.get(barcode);
                    if (score == null) {
                        score = 0;
                    }
                    sb.append(score);
                    sb.append('\t');
                    totalScoreForHairpin += score.intValue();
                }
                if (this.includeScore(totalScoreForHairpin, unexpectedSequenceReportData.getNumberOfReads(), unexpectedSequenceThreshold)) {
                    printWriter.append(hairpinScore.getHairpin());
                    printWriter.append('\t');
                    printWriter.append(String.valueOf(totalScoreForHairpin));
                    printWriter.append('\t');
                    printWriter.append(sb.toString());
                    printWriter.append(TextUtils.join(unexpectedSequenceReportData.getPlatformHairpinIdsForHairpin(hairpinScore.getHairpin()), ','));
                    printWriter.append('\n');
                }
                if (++unexpectedHairpinsProcessed % 10000 != 0) continue;
                logger.info("Processed {} unexpected hairpins", unexpectedHairpinsProcessed);
            }
        }
        catch (Exception e) {
            logger.error("Caught unexpected exception processing unexpected hairpin # {}", unexpectedHairpinsProcessed);
            logger.error("Exception was", e);
        }
    }

    private void writeUnexpectedBarcodeCountHeader(UnexpectedSequenceReportData unexpectedSequenceReportData, int unexpectedSequenceThreshold, PrintWriter printWriter) {
        printWriter.append("Unexpected Barcode\tUnexpected Sequence Count\n");
    }

    private void writeUnexpectedBarcodeCounts(UnexpectedSequenceReportData unexpectedSequenceReportData, int unexpectedSequenceThreshold, PrintWriter printWriter) {
        List<BarcodeCount> unexpectedBarcodeCounts = this.getUnexpectedBarcodeCounts(unexpectedSequenceReportData);
        Collections.sort(unexpectedBarcodeCounts, Collections.reverseOrder());
        for (BarcodeCount barcodeCount : unexpectedBarcodeCounts) {
            printWriter.append(barcodeCount.getBarcode());
            printWriter.append('\t');
            printWriter.append(String.valueOf(barcodeCount.getCount()));
            printWriter.append('\n');
        }
    }

    private List<BarcodeCount> getUnexpectedBarcodeCounts(UnexpectedSequenceReportData unexpectedSequenceReportData) {
        Collection<String> barcodes = unexpectedSequenceReportData.getUnexpectedBarcodes();
        ArrayList<BarcodeCount> counts = new ArrayList<BarcodeCount>(barcodes.size());
        for (String barcode : barcodes) {
            counts.add(new BarcodeCount(barcode, unexpectedSequenceReportData.getUnexpectedHairpinReadCountForBarcode(barcode)));
        }
        return counts;
    }

    boolean includeScore(int observedCount, long totalReads, int unexpectedSequenceThreshold) {
        return (double)observedCount * 1.0E7 / (double)totalReads >= (double)unexpectedSequenceThreshold;
    }

    static final class BarcodeCount
    implements Comparable<BarcodeCount> {
        private final String barcode;
        private final int count;

        public BarcodeCount(String barcode, int count) {
            this.barcode = barcode;
            this.count = count;
        }

        public String getBarcode() {
            return this.barcode;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(BarcodeCount that) {
            int countCmp = this.count - that.count;
            if (countCmp == 0) {
                return this.barcode.compareTo(that.barcode);
            }
            return countCmp;
        }
    }
}

