/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;

public class UtilizationTracker
extends BaseUtilizationTracker {
    public UtilizationTracker(EnvironmentImpl env) {
        super(env, env.getCleaner());
    }

    UtilizationTracker(EnvironmentImpl env, Cleaner cleaner) {
        super(env, cleaner);
    }

    public EnvironmentImpl getEnvironment() {
        return this.env;
    }

    public long evictMemory() throws DatabaseException {
        if (!this.cleaner.trackDetail) {
            return 0L;
        }
        if (!this.env.isValid()) {
            return 0L;
        }
        if (this.env.isReadOnly()) {
            return 0L;
        }
        MemoryBudget mb = this.env.getMemoryBudget();
        long totalEvicted = 0L;
        long totalBytes = 0L;
        int largestBytes = 0;
        TrackedFileSummary bestFile = null;
        for (TrackedFileSummary tfs : this.getTrackedFiles()) {
            int mem = tfs.getMemorySize();
            totalBytes += (long)mem;
            if (mem <= largestBytes || !tfs.getAllowFlush()) continue;
            largestBytes = mem;
            bestFile = tfs;
        }
        if (bestFile != null && totalBytes > mb.getTrackerBudget()) {
            this.env.getUtilizationProfile().flushFileSummary(bestFile);
            totalEvicted += (long)largestBytes;
        }
        return totalEvicted;
    }

    public void activateCleaner() {
        this.env.getCleaner().wakeup();
        this.bytesSinceActivate = 0L;
    }

    public boolean countNewLogEntry(long lsn, LogEntryType type, int size, DatabaseImpl db) {
        return this.countNew(lsn, db, type, size);
    }

    public void countObsoleteNode(long lsn, LogEntryType type, int size, DatabaseImpl db) {
        this.countObsolete(lsn, db, type, size, true, true, true, true);
    }

    public void countObsoleteNodeInexact(long lsn, LogEntryType type, int size, DatabaseImpl db) {
        this.countObsolete(lsn, db, type, size, true, true, false, false);
    }

    public void countObsoleteNodeDupsAllowed(long lsn, LogEntryType type, int size, DatabaseImpl db) {
        this.countObsolete(lsn, db, type, size, true, true, true, false);
    }

    public TrackedFileSummary getUnflushableTrackedSummary(long fileNum) {
        TrackedFileSummary file = this.getFileSummary(fileNum);
        file.setAllowFlush(false);
        return file;
    }

    DbFileSummary getDbFileSummary(Object databaseKey, long fileNum) {
        DatabaseImpl db = (DatabaseImpl)databaseKey;
        if (db != null) {
            return db.getDbFileSummary(fileNum, true);
        }
        return null;
    }
}

