/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.txn.RollbackEnd;
import com.sleepycat.je.txn.RollbackStart;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnPrepare;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;

public class LNFileReader
extends FileReader {
    protected Map<LogEntryType, LogEntry> targetEntryMap;
    protected LogEntry targetLogEntry;
    private long ckptEnd;

    public LNFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, boolean redo, long endOfFileLsn, long finishLsn, Long singleFileNum, long ckptEnd) throws DatabaseException {
        super(env, readBufferSize, redo, startLsn, singleFileNum, endOfFileLsn, finishLsn);
        this.ckptEnd = ckptEnd;
        this.targetEntryMap = new HashMap<LogEntryType, LogEntry>();
    }

    public void addTargetType(LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, entryType.getNewLogEntry());
    }

    protected boolean isTargetEntry() {
        if (this.currentEntryHeader.getProvisional().isProvisional(this.getLastLsn(), this.ckptEnd)) {
            this.targetLogEntry = null;
        } else {
            LogEntryType fromLogType = new LogEntryType(this.currentEntryHeader.getType());
            this.targetLogEntry = this.targetEntryMap.get(fromLogType);
        }
        return this.targetLogEntry != null;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        this.targetLogEntry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        return true;
    }

    public boolean isLN() {
        return this.targetLogEntry instanceof LNLogEntry;
    }

    public LNLogEntry getLNLogEntry() {
        return (LNLogEntry)this.targetLogEntry;
    }

    public boolean isLNDeleted() {
        return ((LNLogEntry)this.targetLogEntry).isDeleted();
    }

    public DatabaseId getDatabaseId() {
        return ((LNLogEntry)this.targetLogEntry).getDbId();
    }

    public Long getTxnId() {
        return ((LNLogEntry)this.targetLogEntry).getTxnId();
    }

    public boolean isPrepare() {
        return this.targetLogEntry.getMainItem() instanceof TxnPrepare;
    }

    public long getTxnPrepareId() {
        return ((TxnPrepare)this.targetLogEntry.getMainItem()).getId();
    }

    public Xid getTxnPrepareXid() {
        return ((TxnPrepare)this.targetLogEntry.getMainItem()).getXid();
    }

    public boolean isCommit() {
        return this.targetLogEntry.getMainItem() instanceof TxnCommit;
    }

    public boolean isRollbackStart() {
        return this.targetLogEntry.getMainItem() instanceof RollbackStart;
    }

    public boolean isRollbackEnd() {
        return this.targetLogEntry.getMainItem() instanceof RollbackEnd;
    }

    public Object getMainItem() {
        return this.targetLogEntry.getMainItem();
    }

    public String dumpCurrentHeader() {
        return this.currentEntryHeader.toString();
    }

    public boolean isAbort() {
        return this.targetLogEntry.getMainItem() instanceof TxnAbort;
    }

    public long getTxnAbortId() {
        return ((TxnAbort)this.targetLogEntry.getMainItem()).getId();
    }

    public long getTxnCommitId() {
        return ((TxnCommit)this.targetLogEntry.getMainItem()).getId();
    }

    public long getAbortLsn() {
        return ((LNLogEntry)this.targetLogEntry).getAbortLsn();
    }

    public boolean getAbortKnownDeleted() {
        return ((LNLogEntry)this.targetLogEntry).getAbortKnownDeleted();
    }

    public boolean isInvisible() {
        return this.currentEntryHeader.isInvisible();
    }

    public byte getLogEntryType() {
        return this.currentEntryHeader.getType();
    }

    public long getVLSN() {
        assert (this.entryIsReplicated());
        return this.currentEntryHeader.getVLSN().getSequence();
    }
}

