/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.broadinstitute.rnai.poolq.api.PoolQFilenameInputs;
import org.broadinstitute.rnai.poolq.api.ReadsFileType;
import org.broadinstitute.rnai.poolq.cli.UnsupportedOptionException;
import org.broadinstitute.rnai.poolq.cli.UsageMessageDisplayedException;
import org.broadinstitute.rnai.poolq.impl.TextUtils;

public class PoolQCommandLineParser {
    private static final String READS_FLAG = "reads";
    private static final String REFERENCE_FLAG = "reference";
    private static final String CONDITIONS_FLAG = "conditions";
    private static final String SCORES_FLAG = "scores";
    private static final String QUALITY_FLAG = "quality";
    private static final String NORM_SCORES_FLAG = "norm-scores";
    private static final String BARCODE_SCORES_FLAG = "barcode-scores";
    private static final String UNEXPECTED_SEQUENCE_REPORT_FLAG = "unexpected-sequences";
    private static final String PLATFORM_REFERENCE_FLAG = "platform-reference";
    private static final String UNEXPECTED_SEQUENCE_REPORT_THRESHOLD_FLAG = "unexpected-sequence-threshold";
    private static final String INCLUDE_NON_PF_FLAG = "include-non-pf";
    private static final String USE_EXACT_MATCH_FLAG = "exact-match";
    private static final String BARCODE_START_FLAG = "barcode-start";
    private static final String HAIRPIN_START_FLAG = "hairpin-start";
    private static final String INCLUDE_AMBIGUOUS_FLAG = "include-ambiguous";
    private static final String MIN_HAIRPIN_LENGTH_FLAG = "min-hairpin-length";
    private static final String SKIP_SHORT_READS_FLAG = "skip-short-reads";
    private static final String READS_FILE_TYPE_FLAG = "reads-file-type";

    public PoolQFilenameInputs parsePoolQInputsFromCommandLineArgs(String[] args) throws UsageMessageDisplayedException {
        Options options = this.initializeOptions();
        try {
            CommandLine commandLine = this.parseCommandLine(args, options);
            this.printUsageMessageAndExitWhenHelpOptionIsPresent(commandLine, options);
            return this.getPoolQInputsFromCommandLine(commandLine);
        }
        catch (ParseException e) {
            this.printUsageMessageAndExit(options);
            return null;
        }
    }

    private PoolQFilenameInputs getPoolQInputsFromCommandLine(CommandLine commandLine) throws ParseException, UnsupportedOptionException {
        final String readsFilename = commandLine.getOptionValue(READS_FLAG);
        final String referenceFilename = commandLine.getOptionValue(REFERENCE_FLAG);
        final String conditionsFilename = commandLine.getOptionValue(CONDITIONS_FLAG);
        final String scoresFilename = commandLine.getOptionValue(SCORES_FLAG);
        final String qualityFilename = commandLine.getOptionValue(QUALITY_FLAG);
        final String logNormalizedScoresFilename = commandLine.getOptionValue(NORM_SCORES_FLAG);
        final String barcodeScoresFilename = commandLine.getOptionValue(BARCODE_SCORES_FLAG);
        final String platformReferenceFilename = commandLine.getOptionValue(PLATFORM_REFERENCE_FLAG);
        final String unexpectedSequenceFilename = commandLine.getOptionValue(UNEXPECTED_SEQUENCE_REPORT_FLAG);
        final Integer unexpectedSequenceThreshold = this.getUnexpectedSequenceThreshold(commandLine);
        final boolean useExactMatch = commandLine.hasOption(USE_EXACT_MATCH_FLAG);
        final boolean includeNonPfReads = commandLine.hasOption(INCLUDE_NON_PF_FLAG);
        final Integer barcodeStartIndex = this.getBarcodeStartIndex(commandLine);
        final Integer hairpinStartIndex = this.getHairpinStartIndex(commandLine);
        final boolean includeAmbiguous = commandLine.hasOption(INCLUDE_AMBIGUOUS_FLAG);
        final Integer minHairpinLength = this.getMinHairpinLength(commandLine);
        final boolean skipShortReads = commandLine.hasOption(SKIP_SHORT_READS_FLAG);
        final ReadsFileType readsFileType = this.getReadsFileType(commandLine);
        return new PoolQFilenameInputs(){

            @Override
            public String getReadsFilename() {
                return readsFilename;
            }

            @Override
            public String getReferenceFilename() {
                return referenceFilename;
            }

            @Override
            public String getConditionsFilename() {
                return conditionsFilename;
            }

            @Override
            public String getScoresFilename() {
                return scoresFilename;
            }

            @Override
            public String getQualityFilename() {
                return qualityFilename;
            }

            @Override
            public String getLogNormalizedScoresFilename() {
                return logNormalizedScoresFilename;
            }

            @Override
            public String getBarcodeScoresFilename() {
                return barcodeScoresFilename;
            }

            @Override
            public String getPlatformReferenceFilename() {
                return platformReferenceFilename;
            }

            @Override
            public String getUnexpectedSequenceFilename() {
                return unexpectedSequenceFilename;
            }

            @Override
            public int getUnexpectedSequenceThreshold() {
                return unexpectedSequenceThreshold;
            }

            @Override
            public boolean requireExactMatch() {
                return useExactMatch;
            }

            @Override
            public boolean includeNonPfReads() {
                return includeNonPfReads;
            }

            @Override
            public int getBarcodeStartIndex() {
                return barcodeStartIndex;
            }

            @Override
            public int getHairpinStartIndex() {
                return hairpinStartIndex;
            }

            @Override
            public int getMinHairpinLength() {
                return minHairpinLength;
            }

            @Override
            public boolean includeAmbiguous() {
                return includeAmbiguous;
            }

            @Override
            public boolean skipShortReads() {
                return skipShortReads;
            }

            @Override
            public ReadsFileType getReadsFileType() {
                return readsFileType;
            }
        };
    }

    private ReadsFileType getReadsFileType(CommandLine commandLine) throws ParseException, UnsupportedOptionException {
        String readsFileTypeParam = commandLine.getOptionValue(READS_FILE_TYPE_FLAG);
        if (readsFileTypeParam != null) {
            try {
                return ReadsFileType.valueOf(readsFileTypeParam.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOptionException("Reads file type " + readsFileTypeParam + " not supported. Must be one of [ " + TextUtils.join(ReadsFileType.values(), ',') + " ]");
            }
        }
        return ReadsFileType.AUTO;
    }

    private Integer getBarcodeStartIndex(CommandLine commandLine) throws ParseException {
        return this.getIntegerArgument(commandLine, BARCODE_START_FLAG, 0);
    }

    private Integer getHairpinStartIndex(CommandLine commandLine) throws ParseException {
        return this.getIntegerArgument(commandLine, HAIRPIN_START_FLAG, 16);
    }

    private Integer getUnexpectedSequenceThreshold(CommandLine commandLine) throws ParseException {
        return this.getIntegerArgument(commandLine, UNEXPECTED_SEQUENCE_REPORT_THRESHOLD_FLAG, 5000);
    }

    private Integer getMinHairpinLength(CommandLine commandLine) throws ParseException {
        return this.getIntegerArgument(commandLine, MIN_HAIRPIN_LENGTH_FLAG, 20);
    }

    private Integer getIntegerArgument(CommandLine commandLine, String flag, Integer defaultValue) throws ParseException {
        if (commandLine.hasOption(flag)) {
            try {
                return Integer.parseInt(commandLine.getOptionValue(flag));
            }
            catch (NumberFormatException e) {
                throw new ParseException(commandLine.getOptionValue(flag));
            }
        }
        return defaultValue;
    }

    private Options initializeOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt("help");
        OptionBuilder.hasArg(false);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Prints usage message and exits.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("version");
        OptionBuilder.hasArg(false);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Prints usage message and exits.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(READS_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("The file containing the sequencing reads in either FASTQ or BAM format. The file may be gzipped or not; if the file is gzipped, it should end with the .gz suffix.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(REFERENCE_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("An input file with two columns: the hairpin 21mer that are contained in the reads, and the Hairpin IDs.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(CONDITIONS_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("An input file with two columns: the barcode, and the condition.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(SCORES_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("An output CSV file with the conditions as columns, the hairpins as rows, and the read counts as the scores.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(QUALITY_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(true);
        OptionBuilder.withDescription("An output text file containing a basic report of the quality control information gathered while processing the reads.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(NORM_SCORES_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("An optional output CSV file with the conditions as columns, the hairpins as rows, and the read counts as the log normalized scores.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(BARCODE_SCORES_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("An optional output CSV file with the barcodes as columns, the hairpins as rows, and the read counts scores.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(PLATFORM_REFERENCE_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("An optional input file with two columns: a hairpin 21mer that is known to exist, and the associated hairpin ID.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(UNEXPECTED_SEQUENCE_REPORT_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("An optional output text file containing a report of sequences found in the reads but not mapped to hairpin IDs by the reference file. If a platform reference file is provided,any hairpins contained there will be identified by hairpin IDs in this file.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(UNEXPECTED_SEQUENCE_REPORT_THRESHOLD_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.isRequired(false);
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("The minimum number of reads per 10 million that need to contain an unexpected sequence before it is included in the unexpected sequence reference file. The default value is 5000 or 0.05%.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(USE_EXACT_MATCH_FLAG);
        OptionBuilder.hasArg(false);
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Use exact matches for hairpins in the reference file");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(INCLUDE_NON_PF_FLAG);
        OptionBuilder.hasArg(false);
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Include non-PF reads [SAM or BAM files only]");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(BARCODE_START_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.withType(Integer.class);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("The index of the start of a barcode within a read. Defaults to 0.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(HAIRPIN_START_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.withType(Integer.class);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("The index of the start of a hairpin within a read. Defaults to 16.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(MIN_HAIRPIN_LENGTH_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.withType(Integer.class);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("The minimum allowable hairpin length. Defaults to 20.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(INCLUDE_AMBIGUOUS_FLAG);
        OptionBuilder.hasArg(false);
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription("Score reads that match ambiguously to all matching hairpins");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(SKIP_SHORT_READS_FLAG);
        OptionBuilder.hasArg(false);
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription("Skip reads too short to contain a barcode and hairpin. Defaults to false.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt(READS_FILE_TYPE_FLAG);
        OptionBuilder.hasArg(true);
        OptionBuilder.withType(String.class);
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Override the reads file type. One of [ BAM, FASTQ, RAW ].");
        options.addOption(OptionBuilder.create());
        return options;
    }

    private CommandLine parseCommandLine(String[] args, Options options) throws ParseException {
        GnuParser commandLineParser = new GnuParser();
        return commandLineParser.parse(options, args, true);
    }

    private void printUsageMessageAndExitWhenHelpOptionIsPresent(CommandLine commandLine, Options options) throws UsageMessageDisplayedException {
        if (commandLine.hasOption("help") || commandLine.hasOption("version")) {
            this.printUsageMessageAndExit(options);
        }
    }

    protected void printUsageMessageAndExit(Options options) throws UsageMessageDisplayedException {
        System.out.println("PoolQ version 1.0.1");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("<program> <args>", options);
        throw new UsageMessageDisplayedException();
    }
}

