/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.broadinstitute.rnai.poolq.gui.PoolQRunCancelledListener;
import org.broadinstitute.rnai.poolq.gui.SwingUtils;

class ProgressIndicatorDialog
extends JDialog {
    private final PoolQRunCancelledListener poolQRunCancelledListener;

    ProgressIndicatorDialog(JFrame parent, PoolQRunCancelledListener poolQRunCancelledListener) {
        super(parent);
        this.poolQRunCancelledListener = poolQRunCancelledListener;
        this.setModal(true);
        this.setTitle("Running PoolQ...");
        this.getContentPane().add(this.createMainPanel(parent));
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    private Component createMainPanel(JFrame parent) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        JLabel label = new JLabel("PoolQ is running. This may take a while. Please be patient!");
        mainPanel.add(label);
        mainPanel.add(Box.createVerticalStrut(5));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ProgressIndicatorDialog.this.confirmCancel()) {
                    ProgressIndicatorDialog.this.poolQRunCancelledListener.poolQRunCancelled();
                }
            }
        });
        mainPanel.add(cancelButton);
        mainPanel.add(Box.createVerticalStrut(5));
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        mainPanel.add(progressBar);
        return mainPanel;
    }

    private boolean confirmCancel() {
        int confirmation = JOptionPane.showConfirmDialog(this.getParent(), "Are you sure you want to cancel the current PoolQ analysis?", "Confirm Cancel", 0, 3);
        return confirmation == 0;
    }
}

