/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TextUtils {
    private TextUtils() {
    }

    public static String buildEnglishLanguageList(List<String> nounPhrases) {
        if (nounPhrases == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (nounPhrases.isEmpty()) {
            return "";
        }
        if (nounPhrases.size() == 1) {
            return nounPhrases.get(0);
        }
        if (nounPhrases.size() == 2) {
            return TextUtils.join(nounPhrases, " and ");
        }
        return TextUtils.join(Arrays.asList(TextUtils.join(nounPhrases.subList(0, nounPhrases.size() - 2), ", "), TextUtils.join(nounPhrases.subList(nounPhrases.size() - 2, nounPhrases.size()), " and ")), ", ");
    }

    public static String join(Iterable<?> objects, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iterator = objects.iterator();
        if (iterator.hasNext()) {
            while (true) {
                sb.append(iterator.next().toString());
                if (!iterator.hasNext()) break;
                sb.append(separator);
            }
            return sb.toString();
        }
        return sb.toString();
    }

    public static String join(Iterable<?> objects, char separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iterator = objects.iterator();
        if (iterator.hasNext()) {
            while (true) {
                sb.append(iterator.next().toString());
                if (!iterator.hasNext()) break;
                sb.append(separator);
            }
            return sb.toString();
        }
        return sb.toString();
    }

    public static <T> String join(T[] strings, char separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length - 1; ++i) {
            sb.append(strings[i]).append(separator);
        }
        if (strings.length > 0) {
            sb.append(strings[strings.length - 1]);
        }
        return sb.toString();
    }
}

