/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class ScoreAggregator {
    private final Map<String, SortedSet<String>> conditionBarcodeMap;

    public ScoreAggregator(Map<String, SortedSet<String>> conditionBarcodeMap) {
        this.conditionBarcodeMap = conditionBarcodeMap;
    }

    public Map<String, Integer> getScoresByCondition(Map<String, Integer> barcodeScores) {
        HashMap<String, Integer> scoresByCondition = new HashMap<String, Integer>();
        for (String condition : this.conditionBarcodeMap.keySet()) {
            int score = this.getScoreForCondition(barcodeScores, condition);
            scoresByCondition.put(condition, score);
        }
        return scoresByCondition;
    }

    public List<Integer> getScoresListByCondition(Map<String, Integer> barcodeScores, List<String> conditions) {
        ArrayList<Integer> scores = new ArrayList<Integer>(conditions.size());
        for (String condition : conditions) {
            scores.add(this.getScoreForCondition(barcodeScores, condition));
        }
        return scores;
    }

    private int getScoreForCondition(Map<String, Integer> barcodeScores, String condition) {
        int conditionScore = 0;
        for (String barcode : this.conditionBarcodeMap.get(condition)) {
            Integer score = barcodeScores.get(barcode);
            if (score == null) continue;
            conditionScore += barcodeScores.get(barcode).intValue();
        }
        return conditionScore;
    }
}

