/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.broadinstitute.rnai.poolq.impl.fileparser.FileParser;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileParserException;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsIterator;

abstract class AbstractReadsIterator
extends FileParser
implements ReadsIterator {
    private boolean alreadyParsedNextRead = false;
    private String nextRead = null;

    AbstractReadsIterator() {
    }

    @Override
    public boolean hasNext() {
        if (!this.alreadyParsedNextRead) {
            this.parseNextRead();
        }
        return this.nextRead != null;
    }

    @Override
    public String next() {
        if (!this.alreadyParsedNextRead) {
            this.parseNextRead();
        }
        if (this.nextRead == null) {
            throw new NoSuchElementException();
        }
        this.alreadyParsedNextRead = false;
        if (!this.isValidRead(this.nextRead)) {
            throw new ReadsFileParserException.NonACGTNReadException(this.nextRead);
        }
        return this.nextRead;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getReadLength() {
        if (!this.alreadyParsedNextRead) {
            this.parseNextRead();
        }
        if (this.nextRead == null) {
            throw new NoSuchElementException();
        }
        return this.nextRead.length();
    }

    protected abstract String getNextRead() throws IOException;

    private void parseNextRead() {
        this.assertFalse(this.alreadyParsedNextRead);
        this.alreadyParsedNextRead = true;
        try {
            this.nextRead = this.getNextRead();
        }
        catch (IOException e) {
            throw new ReadsFileParserException.ReadsFileIOException(e);
        }
    }

    private boolean isValidRead(String read) {
        if (read.isEmpty()) {
            return false;
        }
        block3: for (char c : read.toCharArray()) {
            switch (c) {
                case 'A': 
                case 'C': 
                case 'G': 
                case 'N': 
                case 'T': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void assertFalse(boolean assertion) {
        if (assertion) {
            throw new RuntimeException();
        }
    }
}

