/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;

public class ColumnFileParser
implements Iterable<String[]> {
    static final int FILE_SAMPLE_LENGTH = 1024;
    private final BufferedInputStream inputStream;

    public ColumnFileParser(InputStream inputStream) {
        this.inputStream = new BufferedInputStream(inputStream);
    }

    @Override
    public Iterator<String[]> iterator() {
        return new Iterator<String[]>(){
            final char separator;
            final CSVReader reader;
            String[] next;
            {
                this.separator = ColumnFileParser.this.guessSeparatorChar();
                this.reader = new CSVReader(new InputStreamReader(ColumnFileParser.this.inputStream), this.separator);
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                try {
                    this.next = this.reader.readNext();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading from input stream", e);
                }
                return this.next != null;
            }

            @Override
            public String[] next() {
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported by this iterator");
            }
        };
    }

    public char guessSeparatorChar() {
        this.inputStream.mark(1024);
        char separator = this.guessSeparator(this.inputStream, 1024);
        try {
            this.inputStream.reset();
        }
        catch (IOException e) {
            throw new RuntimeException("Error resetting input stream", e);
        }
        return separator;
    }

    char guessSeparator(InputStream istream, int maxChars) {
        InputStreamReader reader = new InputStreamReader(istream);
        try {
            char[] buffer = new char[maxChars];
            int read = ((Reader)reader).read(buffer, 0, maxChars);
            if (read > 0) {
                int nonNewlineCharsRead = 0;
                for (char c : buffer) {
                    if (c == '\n' || c == '\r') {
                        if (nonNewlineCharsRead <= 0) continue;
                        return ',';
                    }
                    if (c == '\t') {
                        return '\t';
                    }
                    ++nonNewlineCharsRead;
                }
            }
            return ',';
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from input stream", e);
        }
    }
}

