/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.IOException;
import org.broadinstitute.rnai.poolq.api.PoolQException;

public class ReadsFileParserException
extends PoolQException {
    public ReadsFileParserException(String message) {
        super("Error parsing reads file: " + message);
    }

    public ReadsFileParserException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public static class NonACGTNReadException
    extends ReadsFileParserException {
        public NonACGTNReadException(String read) {
            super("Read has non-ATCGN characters in it: " + read);
        }
    }

    public static class ReadsFileIOException
    extends ReadsFileParserException {
        public ReadsFileIOException(IOException e) {
            super("Unexpected I/O exception: " + e.getMessage(), e);
        }
    }
}

