/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.Validate;
import org.broadinstitute.rnai.poolq.api.ReadsFileType;
import org.broadinstitute.rnai.poolq.api.ReadsIterable;
import org.broadinstitute.rnai.poolq.impl.fileparser.FastqReadsIterator;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileInfo;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileParserException;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsIterator;
import org.broadinstitute.rnai.poolq.impl.fileparser.SamReadsIterator;
import org.broadinstitute.rnai.poolq.impl.fileparser.TextReadsIterator;

public class ReadsIterableFactory {
    public ReadsIterable readsIterableFor(String readsFileName, ReadsFileType requestedReadsFileType, Boolean includeNonPfReads) {
        InputStream inputStream;
        ReadsFileInfo fileInfo = ReadsFileInfo.forName(Validate.notNull(readsFileName, "reads file name may not be null", new Object[0]));
        try {
            FileInputStream fis = new FileInputStream(readsFileName);
            inputStream = fileInfo.isGzFile() ? new GZIPInputStream(new BufferedInputStream(fis)) : fis;
        }
        catch (IOException e) {
            throw new ReadsFileParserException.ReadsFileIOException(e);
        }
        ReadsFileType resolvedReadsFileType = requestedReadsFileType == ReadsFileType.AUTO ? fileInfo.getReadsFileType() : requestedReadsFileType;
        switch (resolvedReadsFileType) {
            case FASTQ: {
                return this.fastqIterableFor(inputStream);
            }
            case BAM: {
                return this.samIterableFor(inputStream, includeNonPfReads);
            }
            case RAW: {
                return this.rawIterableFor(inputStream);
            }
        }
        throw new ReadsFileParserException("Unable to recognize file type for " + readsFileName);
    }

    public ReadsIterable samIterableFor(InputStream inputStream, Boolean includeNonPfReads) {
        return this.readsIterableFor(new SamReadsIterator(Validate.notNull(inputStream, "input stream may not be null", new Object[0]), includeNonPfReads));
    }

    public ReadsIterable fastqIterableFor(InputStream inputStream) {
        return this.readsIterableFor(new FastqReadsIterator(Validate.notNull(inputStream, "input stream may not be null", new Object[0])));
    }

    public ReadsIterable rawIterableFor(InputStream inputStream) {
        return this.readsIterableFor(new TextReadsIterator(Validate.notNull(inputStream, "input stream may not be null", new Object[0])));
    }

    public ReadsIterable readsIterableFor(final ReadsIterator iterator) {
        Validate.notNull(iterator, "reads iterator may not be null", new Object[0]);
        return new ReadsIterable(){

            @Override
            public int getReadLength() {
                return iterator.getReadLength();
            }

            @Override
            public Iterator<String> iterator() {
                return iterator;
            }
        };
    }
}

