/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.impl.TextUtils;

public class ReferenceFileParserException
extends PoolQException {
    private final int lineNumber;
    private final String line;

    public ReferenceFileParserException(String message, int lineNumber, String[] cells) {
        super("Error parsing reference file (line " + lineNumber + "): " + message);
        this.lineNumber = lineNumber;
        this.line = TextUtils.join(cells, ',');
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLine() {
        return this.line;
    }

    public static class EmptyReferenceFileException
    extends ReferenceFileParserException {
        public EmptyReferenceFileException(String message, int lineNumber) {
            super(message, lineNumber, new String[0]);
        }
    }

    public static class DuplicateHairpinIdMappingException
    extends ReferenceFileParserException {
        public DuplicateHairpinIdMappingException(String message, int lineNumber, String[] cells) {
            super(message, lineNumber, cells);
        }
    }

    public static class BadHairpinIdException
    extends ReferenceFileParserException {
        public BadHairpinIdException(String message, int lineNumber, String[] cells) {
            super(message, lineNumber, cells);
        }
    }

    public static class BadHairpinException
    extends ReferenceFileParserException {
        public BadHairpinException(String message, int lineNumber, String[] cells) {
            super(message, lineNumber, cells);
        }
    }

    public static class IncorrectNumberOfColumnsException
    extends ReferenceFileParserException {
        public IncorrectNumberOfColumnsException(String message, int lineNumber, String[] cells) {
            super(message, lineNumber, cells);
        }
    }
}

