/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.impl.filewriter.ScoresFileWriter;

public class BarcodeScoresFileWriter
extends ScoresFileWriter {
    @Override
    protected void printHeaders(PoolQScores poolQScores, PrintWriter printWriter) {
        this.printHairpinAndHairpinIdColumns(printWriter);
        Map<String, SortedSet<String>> conditionToBarcodeMap = poolQScores.getConditionToBarcodeMap();
        for (String condition : poolQScores.getConditions()) {
            for (String barcode : conditionToBarcodeMap.get(condition)) {
                printWriter.append('\t').append(barcode);
            }
        }
        printWriter.append('\n');
    }

    @Override
    protected void printBody(PoolQScores poolQScores, PrintWriter printWriter) {
        Map<String, SortedSet<String>> conditionToBarcodeMap = poolQScores.getConditionToBarcodeMap();
        for (String hairpin : poolQScores.getHairpins()) {
            Collection<String> hairpinIds = poolQScores.getHairpinIdsForHairpin(hairpin);
            this.printHairpinAndHairpinIds(printWriter, hairpin, hairpinIds);
            Map<String, Integer> readCountsByBarcode = poolQScores.getScoresByBarcodeForHairpin(hairpin);
            for (String condition : poolQScores.getConditions()) {
                for (String barcode : conditionToBarcodeMap.get(condition)) {
                    Integer barcodeScore = readCountsByBarcode.get(barcode);
                    if (barcodeScore == null) {
                        barcodeScore = 0;
                    }
                    printWriter.append('\t').append(barcodeScore.toString());
                }
            }
            printWriter.append('\n');
        }
    }
}

