/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.impl.data.ScoreAggregator;
import org.broadinstitute.rnai.poolq.impl.filewriter.LogNormalizer;
import org.broadinstitute.rnai.poolq.impl.filewriter.ScoresFileWriter;

public final class LogNormalizedScoresFileWriter
extends ScoresFileWriter {
    private final LogNormalizer normalizer = new LogNormalizer();

    @Override
    protected void printHeaders(PoolQScores poolQScores, PrintWriter printWriter) {
        this.printHairpinAndHairpinIdColumns(printWriter);
        for (String condition : poolQScores.getConditions()) {
            printWriter.append('\t').append(condition);
        }
        printWriter.append('\n');
    }

    @Override
    protected void printBody(PoolQScores poolQScores, PrintWriter printWriter) {
        ScoreAggregator scoreAggregator = new ScoreAggregator(poolQScores.getConditionToBarcodeMap());
        for (String hairpin : poolQScores.getHairpins()) {
            Collection<String> hairpinIds = poolQScores.getHairpinIdsForHairpin(hairpin);
            this.printHairpinAndHairpinIds(printWriter, hairpin, hairpinIds);
            Map<String, Integer> scoresByBarcodeForHairpin = poolQScores.getScoresByBarcodeForHairpin(hairpin);
            Map<String, Integer> scoresByCondition = scoreAggregator.getScoresByCondition(scoresByBarcodeForHairpin);
            for (String condition : poolQScores.getConditions()) {
                Integer readCount = poolQScores.getMatchingHairpinReadCountForCondition(condition);
                double logNormalizedScore = this.normalizer.normalize((Number)scoresByCondition.get(condition), readCount);
                printWriter.append('\t').append(String.valueOf(logNormalizedScore));
            }
            printWriter.append('\n');
        }
    }
}

