/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.impl.networkRestore.NetworkBackup;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkRestore {
    private RepNode repNode;
    private VLSN minVLSN;
    private List<ReplicationNode> logProviders;
    private ReplicationNode logProvider;
    private NetworkBackup backup;
    private Logger logger;

    private List<Server> init(InsufficientLogException logException, NetworkRestoreConfig config) throws IllegalArgumentException {
        this.repNode = logException.getRepNode();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.minVLSN = logException.getRefreshVLSN();
        int loadThreshold = 0;
        if (config.getLogProviders() != null && config.getLogProviders().size() > 0) {
            HashSet<String> memberNames = new HashSet<String>();
            for (ReplicationNode node : logException.getLogProviders()) {
                memberNames.add(node.getName());
            }
            for (ReplicationNode node : config.getLogProviders()) {
                if (memberNames.contains(node.getName())) continue;
                throw new IllegalArgumentException("Node:" + node.getName() + " is not a suitable member for NetworkRestore." + " It's not a member of logException." + "getLogProviders(): " + Arrays.toString(memberNames.toArray()));
            }
            loadThreshold = Integer.MAX_VALUE;
            this.logProviders = config.getLogProviders();
        } else {
            this.logProviders = new LinkedList<ReplicationNode>(logException.getLogProviders());
        }
        LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Started network restore");
        LinkedList<Server> serverList = new LinkedList<Server>();
        for (ReplicationNode node : this.logProviders) {
            serverList.add(new Server(node, loadThreshold));
        }
        return serverList;
    }

    public synchronized void execute(InsufficientLogException logException, NetworkRestoreConfig config) throws EnvironmentFailureException, IllegalArgumentException {
        List<Server> serverList = this.init(logException, config);
        while (!serverList.isEmpty()) {
            Collections.sort(serverList);
            LinkedList<Server> newServerList = new LinkedList<Server>();
            File envHome = this.repNode.getRepImpl().getEnvironmentHome();
            for (Server server : serverList) {
                InetSocketAddress serverSocket = server.node.getSocketAddress();
                if (serverSocket.equals(this.repNode.getSocket())) continue;
                LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Network restore candidate server: " + server.node);
                this.logProvider = server.node;
                long startTime = System.currentTimeMillis();
                try {
                    this.backup = new NetworkBackup(serverSocket, envHome, this.repNode.getNameIdPair(), config.getRetainLogFiles(), server.load, this.minVLSN, this.repNode.getRepImpl(), this.repNode.getRepImpl().getFileManager());
                    this.backup.execute();
                    LoggerUtils.info(this.logger, this.repNode.getRepImpl(), String.format("Network restore completed from: %s. Elapsed time: %,d s.", server.node, (System.currentTimeMillis() - startTime) / 1000L));
                    return;
                }
                catch (DatabaseException e) {
                    LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Backup failed from node: " + server.node + "\n" + e.getMessage());
                }
                catch (ConnectException e) {
                    LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Backup server node: " + server.node + " is not available: " + e.getMessage());
                }
                catch (IOException e) {
                    LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Backup failed from node: " + server.node + "\n" + e.getMessage());
                }
                catch (ServiceDispatcher.ServiceConnectFailedException e) {
                    LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "Backup failed from node: " + server.node + "\n" + e.getMessage());
                }
                catch (NetworkBackup.LoadThresholdExceededException e) {
                    LoggerUtils.info(this.logger, this.repNode.getRepImpl(), e.getMessage());
                    newServerList.add(new Server(server.node, e.getActiveServers()));
                }
                catch (NetworkBackup.InsufficientVLSNRangeException e) {
                    LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Backup failed from node: " + server.node + " Error: " + e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
            }
            serverList = newServerList;
        }
        throw EnvironmentFailureException.unexpectedState("Tried and failed with every node");
    }

    public NetworkBackup getBackup() {
        return this.backup;
    }

    public ReplicationNode getLogProvider() {
        return this.logProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Server
    implements Comparable<Server> {
        private final ReplicationNode node;
        private final int load;

        public Server(ReplicationNode node, int load) {
            this.node = node;
            this.load = load;
        }

        @Override
        public int compareTo(Server o) {
            return this.load - o.load;
        }

        public String toString() {
            return this.node.getName();
        }
    }
}

