/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.utilint.CmdUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbGroupAdmin {
    private String groupName;
    private Set<InetSocketAddress> helperSockets;
    private String nodeName;
    private String newHostName;
    private int newPort;
    private int retries = 5;
    private int retryInterval = 10;
    private ReplicationGroupAdmin groupAdmin;
    private final ArrayList<Command> actions = new ArrayList();
    private static final String usageString = "Usage: " + CmdUtil.getJavaCommand(DbGroupAdmin.class) + "\n" + "  -groupName <group name>   # name of replication group\n" + "  -helperHosts <host:port>  # identifier for one or more members\n" + "                            # of the replication group which can\n" + "                            # be contacted for group information,\n" + "                            # in this format:\n" + "                            # hostname[:port][,hostname[:port]]\n" + "  -dumpGroup                # dump group information\n" + "  -removeMember <node name> # node to be removed\n" + "  -updateAddress <node name> <new host:port>\n" + "                            # update the network address for a\n " + "                            # specified node. The node should\n" + "                            # not be alive when updating the address";

    public static void main(String[] args) throws Exception {
        DbGroupAdmin admin = new DbGroupAdmin();
        admin.parseArgs(args);
        admin.run();
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-groupName")) {
                if (argc < nArgs) {
                    this.groupName = argv[argc++];
                    continue;
                }
                this.printUsage("-groupName requires an argument");
                continue;
            }
            if (thisArg.equals("-helperHosts")) {
                if (argc < nArgs) {
                    this.helperSockets = HostPortPair.getSockets(argv[argc++]);
                    continue;
                }
                this.printUsage("-helperHosts requires an argument");
                continue;
            }
            if (thisArg.equals("-dumpGroup")) {
                this.actions.add(Command.DUMP);
                continue;
            }
            if (thisArg.equals("-removeMember")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    this.actions.add(Command.REMOVE);
                    continue;
                }
                this.printUsage("-removeMember requires an argument");
                continue;
            }
            if (thisArg.equals("-updateAddress")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    if (argc < nArgs) {
                        String hostPort;
                        int index;
                        if ((index = (hostPort = argv[argc++]).indexOf(":")) < 0) {
                            this.printUsage("Host port pair format must be <host name>:<port number>");
                        }
                        this.newHostName = hostPort.substring(0, index);
                        this.newPort = Integer.parseInt(hostPort.substring(index + 1, hostPort.length()));
                    } else {
                        this.printUsage("-updateAddress requires a <host name>:<port number> argument");
                    }
                    this.actions.add(Command.UPDATE_ADDRESS);
                    continue;
                }
                this.printUsage("-updateAddress requires the node name argument");
                continue;
            }
            if (thisArg.equals("-transferMaster")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    if (argc < nArgs) {
                        this.retries = Integer.parseInt(argv[argc++]);
                    }
                    if (argc < nArgs) {
                        this.retryInterval = Integer.parseInt(argv[argc++]);
                    }
                    this.actions.add(Command.TRANSFER_MASTER);
                    continue;
                }
                this.printUsage("-transferMaster requires at least one argument");
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
    }

    private void run() throws Exception {
        this.createGroupAdmin();
        if (this.actions.size() == 0) {
            return;
        }
        for (Command action : this.actions) {
            if (action == Command.DUMP) {
                this.dumpGroup();
            }
            if (action == Command.REMOVE) {
                this.removeMember(this.nodeName);
            }
            if (action == Command.TRANSFER_MASTER) {
                this.transferMastership(this.nodeName, this.retries, this.retryInterval, TimeUnit.SECONDS);
            }
            if (action != Command.UPDATE_ADDRESS) continue;
            this.updateAddress(this.nodeName, this.newHostName, this.newPort);
        }
    }

    private DbGroupAdmin() {
    }

    public DbGroupAdmin(String groupName, Set<InetSocketAddress> helperSockets) {
        this.groupName = groupName;
        this.helperSockets = helperSockets;
        this.createGroupAdmin();
    }

    private void createGroupAdmin() {
        if (this.groupName == null) {
            this.printUsage("Group name must be specified");
        }
        if (this.helperSockets == null || this.helperSockets.size() == 0) {
            this.printUsage("Host and ports of helper nodes must be specified");
        }
        this.groupAdmin = new ReplicationGroupAdmin(this.groupName, this.helperSockets);
    }

    public void dumpGroup() {
        System.out.println(this.getFormattedOutput());
    }

    public void removeMember(String name) {
        if (name == null) {
            this.printUsage("Node name must be specified");
        }
        this.groupAdmin.removeMember(name);
    }

    public void updateAddress(String nodeName, String newHostName, int newPort) {
        if (nodeName == null || newHostName == null) {
            this.printUsage("Node name and new host name must be specified");
        }
        if (newPort <= 0) {
            this.printUsage("Port of the new network address must be specified");
        }
        this.groupAdmin.updateAddress(nodeName, newHostName, newPort);
    }

    public void transferMastership(String nodeName, int retries, int retryInterval, TimeUnit timeUnit) throws InterruptedException {
        if (nodeName == null) {
            this.printUsage("The name of the replica which will become the new master must be specified");
        }
        if (retries <= 0 && retryInterval <= 0) {
            this.printUsage("Retry times and retry interval must be a positive number");
        }
        this.groupAdmin.transferMastership(nodeName, retries, retryInterval, timeUnit);
    }

    private String getFormattedOutput() {
        StringBuilder sb = new StringBuilder();
        RepGroupImpl repGroupImpl = this.groupAdmin.getGroup().getRepGroupImpl();
        String masterName = this.groupAdmin.getMasterNodeName();
        sb.append("\nGroup: " + repGroupImpl.getName() + "\n");
        sb.append("Electable Members:\n");
        Set<RepNodeImpl> nodes = repGroupImpl.getAllElectableMembers();
        if (nodes.size() == 0) {
            sb.append("    No electable members\n");
        } else {
            for (RepNodeImpl node : nodes) {
                String type = masterName.equals(node.getName()) ? "master, " : "";
                sb.append("    " + node.getName() + " (" + type + node.getHostName() + ":" + node.getPort() + ", " + node.getBarrierState() + ")\n");
            }
        }
        sb.append("\nMonitor Members:\n");
        nodes = repGroupImpl.getMonitorNodes();
        if (nodes.size() == 0) {
            sb.append("    No monitors\n");
        } else {
            for (RepNodeImpl node : nodes) {
                sb.append("    " + node.getName() + " (" + node.getHostName() + ":" + node.getPort() + ")\n");
            }
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Command {
        DUMP,
        REMOVE,
        TRANSFER_MASTER,
        UPDATE_ADDRESS;

    }
}

