/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import java.nio.ByteBuffer;

public final class MapLN
extends LN {
    private static final String BEGIN_TAG = "<mapLN>";
    private static final String END_TAG = "</mapLN>";
    private final DatabaseImpl databaseImpl;
    private boolean deleted;

    public MapLN(DatabaseImpl db) {
        super(new byte[0]);
        this.databaseImpl = db;
        this.deleted = false;
    }

    public MapLN() {
        this.databaseImpl = new DatabaseImpl();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    void makeDeleted() {
        this.deleted = true;
        this.databaseImpl.getTree().setRoot(null, true);
    }

    public DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    boolean isEvictableInexact() {
        return this.databaseImpl.getDbEnvironment().getDbEviction() && !this.databaseImpl.isInUse() && !this.databaseImpl.getTree().isRootResident();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEvictable(long lsn) throws DatabaseException {
        boolean evictable = false;
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        BasicLocker locker = BasicLocker.createBasicLocker(envImpl);
        DatabaseImpl idDatabaseImpl = envImpl.getDbTree().getIdDatabaseImpl();
        try {
            LockResult lockResult = locker.nonBlockingLock(lsn, LockType.WRITE, false, idDatabaseImpl);
            if (lockResult.getLockGrant() != LockGrantType.DENIED && this.isEvictableInexact()) {
                evictable = true;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            locker.operationEnd();
            throw throwable;
        }
        locker.operationEnd();
        return evictable;
    }

    public void postFetchInit(DatabaseImpl db, long sourceLsn) {
        this.databaseImpl.setEnvironmentImpl(db.getDbEnvironment());
    }

    public long getMemorySizeIncludedByParent() {
        return MemoryBudget.MAPLN_OVERHEAD;
    }

    public void releaseMemoryBudget() {
        this.databaseImpl.releaseTreeAdminMemory();
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<deleted val=\"").append(Boolean.toString(this.deleted));
        sb.append("\">");
        sb.append('\n');
        sb.append(this.databaseImpl.dumpString(nSpaces));
        return sb.toString();
    }

    protected LogEntryType getLogType(boolean isInsert, boolean isTransactional) {
        return isTransactional ? LogEntryType.LOG_MAPLN_TRANSACTIONAL : LogEntryType.LOG_MAPLN;
    }

    public int getLogSize() {
        return super.getLogSize() + this.databaseImpl.getLogSize() + 1;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.databaseImpl.writeToLog(logBuffer);
        byte booleans = (byte)(this.deleted ? 1 : 0);
        logBuffer.put(booleans);
    }

    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        super.readFromLog(itemBuffer, entryVersion);
        this.databaseImpl.readFromLog(itemBuffer, entryVersion);
        byte booleans = itemBuffer.get();
        this.deleted = (booleans & 1) != 0;
    }

    public boolean logicalEquals(Loggable other) {
        return false;
    }

    protected void dumpLogAdditional(StringBuilder sb, boolean verbose) {
        this.databaseImpl.dumpLog(sb, verbose);
    }
}

