/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.cli;

import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.api.PoolQFilenameInputs;
import org.broadinstitute.rnai.poolq.cli.PoolQCommandLineParser;
import org.broadinstitute.rnai.poolq.cli.PoolQOptionsSummary;
import org.broadinstitute.rnai.poolq.cli.UsageMessageDisplayedException;
import org.broadinstitute.rnai.poolq.impl.PoolQImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolQCli {
    private static final Logger logger = LoggerFactory.getLogger(PoolQCli.class);

    public static void main(String[] args) {
        PoolQCommandLineParser commandLineParser = new PoolQCommandLineParser();
        try {
            PoolQFilenameInputs poolQFilenameInputs = commandLineParser.parsePoolQInputsFromCommandLineArgs(args);
            logger.info(new PoolQOptionsSummary().buildOptionsSummary(poolQFilenameInputs));
            PoolQImpl poolQ = new PoolQImpl();
            poolQ.runPoolQ(poolQFilenameInputs);
        }
        catch (UsageMessageDisplayedException e) {
        }
        catch (PoolQException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }
}

