/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui.filechooser;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserPanelType;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileSelectionPanel;

public class FileChooserPanelFactory {
    private Map<FileChooserPanelType, JLabel> fileChooserTypeToLabel = new HashMap<FileChooserPanelType, JLabel>();

    public FileChooserPanelFactory() {
        for (FileChooserPanelType fileChooserPanelType : FileChooserPanelType.values()) {
            JLabel label = new JLabel(fileChooserPanelType.getLabelText());
            this.fileChooserTypeToLabel.put(fileChooserPanelType, label);
        }
        Integer maxLabelWidth = null;
        for (JLabel label : this.fileChooserTypeToLabel.values()) {
            int labelWidth = label.getPreferredSize().width;
            if (maxLabelWidth != null && maxLabelWidth >= labelWidth) continue;
            maxLabelWidth = labelWidth;
        }
        for (JLabel label : this.fileChooserTypeToLabel.values()) {
            label.setPreferredSize(new Dimension(maxLabelWidth, label.getPreferredSize().height));
        }
    }

    public FileSelectionPanel buildFileChooserPanel(FileChooserPanelType fileChooserPanelType) {
        JLabel label = this.fileChooserTypeToLabel.get((Object)fileChooserPanelType);
        return new FileSelectionPanel(label, fileChooserPanelType);
    }
}

