/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.PoolQ;
import org.broadinstitute.rnai.poolq.api.PoolQDataInputs;
import org.broadinstitute.rnai.poolq.api.PoolQDataOutputs;
import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.api.PoolQFilenameInputs;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.api.QualityReportData;
import org.broadinstitute.rnai.poolq.api.ReadsFileType;
import org.broadinstitute.rnai.poolq.api.ReadsIterable;
import org.broadinstitute.rnai.poolq.api.UnexpectedSequenceReportData;
import org.broadinstitute.rnai.poolq.impl.data.PoolQDataImpl;
import org.broadinstitute.rnai.poolq.impl.fileparser.ConditionsFileParser;
import org.broadinstitute.rnai.poolq.impl.fileparser.ConditionsFileParserException;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileParserException;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsIterableFactory;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReferenceFileParser;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReferenceFileParserException;
import org.broadinstitute.rnai.poolq.impl.filewriter.BarcodeScoresFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.LogNormalizedScoresFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.QualityReportFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.ScoresFileWriter;
import org.broadinstitute.rnai.poolq.impl.filewriter.ScoresFileWriterFactory;
import org.broadinstitute.rnai.poolq.impl.filewriter.UnexpectedSequenceFileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolQImpl
implements PoolQ {
    private static final Logger logger = LoggerFactory.getLogger(PoolQImpl.class);

    @Override
    public void runPoolQ(PoolQFilenameInputs poolQFilenameInputs) throws PoolQException {
        PoolQDataInputs poolQDataInputs = this.buildPoolQDataInputsWrapIOException(poolQFilenameInputs);
        PoolQDataImpl poolQData = new PoolQDataImpl(poolQDataInputs);
        try {
            String barcodeScoresFilename;
            logger.info("Beginning PoolQ");
            PoolQDataOutputs poolQDataOutputs = poolQData.runPoolQ();
            logger.info("Reads processing complete, writing reports");
            PoolQScores poolQScores = poolQDataOutputs.getPoolQScores();
            this.writeScoresFile(poolQScores, poolQFilenameInputs.getScoresFilename());
            String logNormalizedScoresFilename = poolQFilenameInputs.getLogNormalizedScoresFilename();
            if (logNormalizedScoresFilename != null) {
                this.writeLogNormalizedScoresFile(poolQScores, logNormalizedScoresFilename);
            }
            if ((barcodeScoresFilename = poolQFilenameInputs.getBarcodeScoresFilename()) != null) {
                this.writeBarcodeScoresFile(poolQScores, barcodeScoresFilename);
            }
            QualityReportData qualityReportData = poolQDataOutputs.getQualityReportData();
            this.writeQualityFile(qualityReportData, poolQFilenameInputs.getQualityFilename());
            String unexpectedSequenceFilename = poolQFilenameInputs.getUnexpectedSequenceFilename();
            if (unexpectedSequenceFilename != null) {
                this.writeUnexpectedSequenceFile(poolQDataOutputs.getUnexpectedSequenceReportData(), poolQFilenameInputs.getUnexpectedSequenceThreshold(), unexpectedSequenceFilename);
            }
            logger.info("PoolQ completed, closing data");
        }
        catch (RuntimeException e) {
            logger.error("Caught unexpected error while running PoolQ", e);
            throw e;
        }
        finally {
            poolQData.close();
        }
    }

    private PoolQDataInputs buildPoolQDataInputsWrapIOException(PoolQFilenameInputs poolQFilenameInputs) throws PoolQException {
        try {
            return this.buildPoolQDataInputs(poolQFilenameInputs);
        }
        catch (IOException e) {
            throw new PoolQException("Problem opening file: " + e.getMessage(), e);
        }
    }

    private PoolQDataInputs buildPoolQDataInputs(final PoolQFilenameInputs poolQFilenameInputs) throws IOException {
        String referenceFilename = poolQFilenameInputs.getReferenceFilename();
        final Map<String, List<String>> hairpinToHairpinIdsMap = this.getHairpinToHairpinIdsMap(referenceFilename, poolQFilenameInputs.getMinHairpinLength());
        String platformReferenceFilename = poolQFilenameInputs.getPlatformReferenceFilename();
        final Map<Object, Object> platformHairpinToHairpinIdsMap = platformReferenceFilename == null ? Collections.emptyMap() : this.getHairpinToHairpinIdsMap(platformReferenceFilename, poolQFilenameInputs.getMinHairpinLength());
        String conditionsFilename = poolQFilenameInputs.getConditionsFilename();
        final Map<String, String> barcodeToConditionsMap = this.getBarcodeToConditionMap(conditionsFilename);
        String readsFilename = poolQFilenameInputs.getReadsFilename();
        final ReadsIterable readsIterable = this.getReadsIterable(readsFilename, poolQFilenameInputs.getReadsFileType(), poolQFilenameInputs.includeNonPfReads());
        return new PoolQDataInputs(){

            @Override
            public Map<String, List<String>> getHairpinToHairpinIdsMap() {
                return hairpinToHairpinIdsMap;
            }

            @Override
            public Map<String, List<String>> getPlatformHairpinToHairpinIdsMap() {
                return platformHairpinToHairpinIdsMap;
            }

            @Override
            public Map<String, String> getBarcodeToConditionMap() {
                return barcodeToConditionsMap;
            }

            @Override
            public ReadsIterable getReadsIterable() {
                return readsIterable;
            }

            @Override
            public int getBarcodeStartIndex() {
                return poolQFilenameInputs.getBarcodeStartIndex();
            }

            @Override
            public int getBarcodeLength() {
                return ((String)barcodeToConditionsMap.keySet().iterator().next()).length();
            }

            @Override
            public int getHairpinStartIndex() {
                return poolQFilenameInputs.getHairpinStartIndex();
            }

            @Override
            public int getHairpinLength() {
                return ((String)hairpinToHairpinIdsMap.keySet().iterator().next()).length();
            }

            @Override
            public int getMinHairpinLength() {
                return poolQFilenameInputs.getMinHairpinLength();
            }

            @Override
            public boolean requireExactMatch() {
                return poolQFilenameInputs.requireExactMatch();
            }

            @Override
            public boolean scoreAmbiguousMatches() {
                return poolQFilenameInputs.includeAmbiguous();
            }

            @Override
            public boolean skipShortReads() {
                return poolQFilenameInputs.skipShortReads();
            }
        };
    }

    private Map<String, List<String>> getHairpinToHairpinIdsMap(String referenceFilename, int minHairpinLength) throws IOException, ReferenceFileParserException {
        ReferenceFileParser referenceFileParser = new ReferenceFileParser(minHairpinLength);
        InputStream inputStream = this.getInputStreamForFilename(referenceFilename);
        return referenceFileParser.parseHairpinToHairpinIdsMapFromInputStream(inputStream);
    }

    private Map<String, String> getBarcodeToConditionMap(String conditionsFilename) throws IOException, ConditionsFileParserException {
        ConditionsFileParser conditionsFileParser = new ConditionsFileParser();
        InputStream inputStream = this.getInputStreamForFilename(conditionsFilename);
        return conditionsFileParser.parseBarcodeToConditionMapFromInputStream(inputStream);
    }

    private ReadsIterable getReadsIterable(String readsFilename, ReadsFileType readsFileType, Boolean includeNonPfReads) throws ReadsFileParserException, IOException {
        return new ReadsIterableFactory().readsIterableFor(readsFilename, readsFileType, includeNonPfReads);
    }

    private InputStream getInputStreamForFilename(String filename) throws FileNotFoundException {
        File referenceFile = new File(filename);
        return new FileInputStream(referenceFile);
    }

    private void writeScoresFile(PoolQScores poolQScores, String scoresFilename) throws PoolQException {
        OutputStream outputStream = this.getOutputStreamForFilename(scoresFilename);
        ScoresFileWriter scoresFileWriter = new ScoresFileWriterFactory().createScoresFileWriter(scoresFilename);
        scoresFileWriter.writeScoresFile(poolQScores, outputStream);
    }

    private void writeLogNormalizedScoresFile(PoolQScores poolQScores, String logNormalizedScoresFilename) {
        OutputStream outputStream = this.getOutputStreamForFilename(logNormalizedScoresFilename);
        new LogNormalizedScoresFileWriter().writeScoresFile(poolQScores, outputStream);
    }

    private void writeBarcodeScoresFile(PoolQScores poolQScores, String barcodeScoresFilename) {
        OutputStream outputStream = this.getOutputStreamForFilename(barcodeScoresFilename);
        new BarcodeScoresFileWriter().writeScoresFile(poolQScores, outputStream);
    }

    private void writeQualityFile(QualityReportData qualityReportData, String qualityFilename) throws PoolQException {
        OutputStream outputStream = this.getOutputStreamForFilename(qualityFilename);
        new QualityReportFileWriter().writeQualityReportFile(qualityReportData, outputStream);
    }

    private void writeUnexpectedSequenceFile(UnexpectedSequenceReportData unexpectedSequenceReportData, int unexpectedSequenceThreshold, String unexpectedSequenceFilename) throws PoolQException {
        OutputStream outputStream = this.getOutputStreamForFilename(unexpectedSequenceFilename);
        new UnexpectedSequenceFileWriter().writeUnexpectedSequenceFile(unexpectedSequenceReportData, unexpectedSequenceThreshold, outputStream);
    }

    private OutputStream getOutputStreamForFilename(String filename) throws PoolQException {
        File referenceFile = new File(filename);
        try {
            return new FileOutputStream(referenceFile);
        }
        catch (FileNotFoundException e) {
            throw new PoolQException("Problem opening file for writing: " + e.getMessage(), e);
        }
    }
}

