/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.HairpinScore;
import org.broadinstitute.rnai.poolq.impl.data.MutableInt;

@Entity
public class HairpinToReadCounts
implements HairpinScore {
    @PrimaryKey
    private String hairpin;
    private Map<String, MutableInt> readCounts = new HashMap<String, MutableInt>();

    @Override
    public String getHairpin() {
        return this.hairpin;
    }

    public void setHairpin(String hairpin) {
        this.hairpin = hairpin;
    }

    @Override
    public Map<String, Integer> getReadCountsByBarcode() {
        HashMap<String, Integer> readCountsByBarcode = new HashMap<String, Integer>();
        for (Map.Entry<String, MutableInt> entry : this.readCounts.entrySet()) {
            readCountsByBarcode.put(entry.getKey(), entry.getValue().toInteger());
        }
        return readCountsByBarcode;
    }

    public void incrementCount(String barcode) {
        MutableInt n = this.readCounts.get(barcode);
        if (n == null) {
            this.readCounts.put(barcode, new MutableInt(1));
        } else {
            n.increment();
        }
    }

    public void setCount(String barcode, int count) {
        this.readCounts.put(barcode, new MutableInt(count));
    }
}

