/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import gnu.trove.map.TMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.HairpinScore;
import org.broadinstitute.rnai.poolq.impl.data.HairpinToReadCounts;
import org.broadinstitute.rnai.poolq.impl.data.ReadCountDatabase;
import org.broadinstitute.rnai.poolq.impl.data.ReadOnlyIterator;

public class InMemoryReadCountDatabase
implements ReadCountDatabase {
    private final List<String> barcodes;
    private final TMap<String, TObjectIntMap<String>> hairpinToScoresMap = new THashMap<String, TObjectIntMap<String>>();

    public InMemoryReadCountDatabase(List<String> barcodes) {
        this.barcodes = barcodes;
    }

    @Override
    public void countHairpinAndBarcode(String hairpin, String barcode) {
        TObjectIntMap<String> scoresMap = this.getScoresMapForHairpin(hairpin);
        scoresMap.adjustOrPutValue(barcode, 1, 1);
    }

    @Override
    public Iterator<HairpinScore> iterator() {
        return new ReadOnlyIterator<HairpinScore>(){
            private final Iterator<Map.Entry<String, TObjectIntMap<String>>> entryIterator;
            {
                this.entryIterator = InMemoryReadCountDatabase.this.hairpinToScoresMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public HairpinScore next() {
                Map.Entry<String, TObjectIntMap<String>> entry = this.entryIterator.next();
                String hairpin = entry.getKey();
                TObjectIntMap<String> hairpinScores = entry.getValue();
                final HairpinToReadCounts hairpinToReadCounts = new HairpinToReadCounts();
                hairpinToReadCounts.setHairpin(hairpin);
                hairpinScores.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String barcode, int count) {
                        hairpinToReadCounts.setCount(barcode, count);
                        return true;
                    }
                });
                return hairpinToReadCounts;
            }
        };
    }

    public List<Integer> getScoresForHairpin(String hairpin) {
        ArrayList<Integer> scores = new ArrayList<Integer>(this.barcodes.size());
        TObjectIntMap<String> scoresMap = this.getScoresMapForHairpin(hairpin);
        for (String barcode : this.barcodes) {
            scores.add(scoresMap.get(barcode));
        }
        return scores;
    }

    @Override
    public Integer getScoreForHairpinAndBarcode(String hairpin, String barcode) {
        TObjectIntMap<String> map = this.getScoresMapForHairpin(hairpin);
        if (map != null) {
            return map.get(barcode);
        }
        return null;
    }

    @Override
    public Map<String, Integer> getScoresByBarcodeForHairpin(String hairpin) {
        HashMap<String, Integer> scoresByBarcode = new HashMap<String, Integer>();
        for (String barcode : this.barcodes) {
            scoresByBarcode.put(barcode, this.getScoreForHairpinAndBarcode(hairpin, barcode));
        }
        return scoresByBarcode;
    }

    private TObjectIntMap<String> getScoresMapForHairpin(String hairpin) {
        TObjectIntHashMap scoresMap = (TObjectIntHashMap)this.hairpinToScoresMap.get(hairpin);
        if (scoresMap == null) {
            scoresMap = new TObjectIntHashMap();
            this.hairpinToScoresMap.put(hairpin, scoresMap);
        }
        return scoresMap;
    }
}

