/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.broadinstitute.rnai.poolq.api.HairpinScore;
import org.broadinstitute.rnai.poolq.api.PoolQDataInputs;
import org.broadinstitute.rnai.poolq.api.PoolQDataOutputs;
import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.api.QualityReportData;
import org.broadinstitute.rnai.poolq.api.UnexpectedSequenceReportData;
import org.broadinstitute.rnai.poolq.impl.PoolQInterruptedException;
import org.broadinstitute.rnai.poolq.impl.QualityReportDataImpl;
import org.broadinstitute.rnai.poolq.impl.data.HairpinTempDatabase;
import org.broadinstitute.rnai.poolq.impl.data.InMemoryReadCountDatabase;
import org.broadinstitute.rnai.poolq.impl.data.ReadCountTempDatabase;
import org.broadinstitute.rnai.poolq.impl.data.ReadProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolQDataImpl {
    private static final Logger logger = LoggerFactory.getLogger(PoolQDataImpl.class);
    private static final int NUM_READS_PER_PROGRESS_REPORT = 1000000;
    private static final int NUM_READS_PER_INTERRUPTION_CHECKPOINT = 10000;
    private static final int TOO_MANY_NS = 2;
    private final ReadProcessor readProcessor;
    private final PoolQDataInputs poolQDataInputs;
    private List<String> conditions;
    private final HairpinTempDatabase hairpinTempDatabase;
    private final InMemoryReadCountDatabase readCountDatabase;
    private final ReadCountTempDatabase unexpectedReadCountDatabase;
    private final TObjectIntMap<String> barcodeToReadCountMap;
    private final TObjectIntMap<String> unexpectedHairpinUnknownBarcodeReadCount;
    private final TObjectIntMap<String> barcodeToMatchingHairpinReadCountMap;
    private long skippedShortReads = 0L;
    private long numberOfReads = 0L;
    private long numberOfMatchingReads = 0L;
    private long numberOfSingleBaseMismatchReads = 0L;

    public static TObjectIntMap<String> buildNewBarcodeToReadCountMap(Collection<String> barcodes) {
        return new TObjectIntHashMap<String>();
    }

    public PoolQDataImpl(PoolQDataInputs poolQDataInputs) {
        this.poolQDataInputs = poolQDataInputs;
        this.readProcessor = new ReadProcessor(poolQDataInputs.getReadsIterable().getReadLength(), poolQDataInputs.getBarcodeStartIndex(), poolQDataInputs.getBarcodeLength(), poolQDataInputs.getHairpinStartIndex(), poolQDataInputs.getHairpinLength(), poolQDataInputs.getMinHairpinLength());
        this.hairpinTempDatabase = new HairpinTempDatabase(this.readProcessor);
        this.conditions = new ArrayList<String>(new LinkedHashSet<String>(poolQDataInputs.getBarcodeToConditionMap().values()));
        this.readCountDatabase = new InMemoryReadCountDatabase(new ArrayList<String>(poolQDataInputs.getBarcodeToConditionMap().keySet()));
        this.unexpectedReadCountDatabase = new ReadCountTempDatabase();
        this.hairpinTempDatabase.buildHairpinVariantDatabase(poolQDataInputs.getHairpinToHairpinIdsMap().keySet(), !poolQDataInputs.requireExactMatch());
        this.barcodeToReadCountMap = PoolQDataImpl.buildNewBarcodeToReadCountMap(poolQDataInputs.getBarcodeToConditionMap().keySet());
        this.barcodeToMatchingHairpinReadCountMap = new TObjectIntHashMap<String>();
        this.unexpectedHairpinUnknownBarcodeReadCount = new TObjectIntHashMap<String>();
    }

    public PoolQDataOutputs runPoolQ() throws PoolQException {
        long t0 = System.currentTimeMillis();
        try {
            for (String read : this.poolQDataInputs.getReadsIterable()) {
                if (this.poolQDataInputs.skipShortReads()) {
                    if (!this.readProcessor.isReadLongEnough(read)) {
                        ++this.skippedShortReads;
                        continue;
                    }
                } else {
                    this.readProcessor.assertReadIsLongEnough(read);
                }
                String barcode = this.readProcessor.getBarcodeFromRead(read);
                String hairpinVariant = this.readProcessor.getHairpinFromRead(read);
                if (barcode.contains("N")) continue;
                this.incrementCountForBarcode(this.barcodeToReadCountMap, barcode);
                String condition = this.poolQDataInputs.getBarcodeToConditionMap().get(barcode);
                ++this.numberOfReads;
                this.incrementScoreForHairpinVariant(barcode, condition, hairpinVariant);
                if (this.numberOfReads % 1000000L == 0L) {
                    logger.info("Processed {} reads ({} reads/ms)", this.numberOfReads, (Object)(1.0 * (double)this.numberOfReads / (double)(System.currentTimeMillis() - t0)));
                }
                if (this.numberOfReads % 10000L != 0L || !Thread.interrupted()) continue;
                throw new PoolQInterruptedException();
            }
            logger.debug("Finished reads file, will clean up temp databases");
            PoolQDataOutputs i$ = this.getPoolQDataOutputs();
            return i$;
        }
        catch (RuntimeException e) {
            logger.error("Caught unexpected exception while running PoolQ", e);
            throw e;
        }
        finally {
            logger.debug("Cleaning up hairpin temp database");
            this.hairpinTempDatabase.prepareForRemoval();
            logger.debug("Cleaning up temp databases complete");
        }
    }

    public void close() {
        try {
            this.unexpectedReadCountDatabase.prepareForRemoval();
        }
        catch (RuntimeException e) {
            logger.error("Caught unexpected exception while closing PoolQ data", e);
            throw e;
        }
    }

    private void incrementScoreForHairpinVariant(String barcode, String condition, String hairpinVariant) {
        List<String> hairpins = this.hairpinTempDatabase.getHairpinsForHairpinVariant(hairpinVariant);
        if (hairpins.size() == 1 || hairpins.size() > 1 && this.poolQDataInputs.scoreAmbiguousMatches()) {
            ++this.numberOfMatchingReads;
            for (String hairpin : hairpins) {
                String truncatedHairpin = this.readProcessor.truncateHairpin(hairpin);
                if (!truncatedHairpin.equals(hairpinVariant)) {
                    ++this.numberOfSingleBaseMismatchReads;
                }
                if (condition == null) continue;
                this.barcodeToMatchingHairpinReadCountMap.adjustOrPutValue(barcode, 1, 1);
                this.readCountDatabase.countHairpinAndBarcode(hairpin, barcode);
            }
        } else if (this.readProcessor.hasFewerThanKNs(hairpinVariant, 2)) {
            this.handleUnexpectedHairpin(hairpinVariant, barcode, condition);
        }
    }

    private void handleUnexpectedHairpin(String hairpin, String barcode, String condition) {
        if (condition != null) {
            this.countUnexpectedHairpinAndBarcode(hairpin, barcode);
        } else {
            this.unexpectedHairpinUnknownBarcodeReadCount.adjustOrPutValue(barcode, 1, 1);
        }
    }

    private void incrementCountForBarcode(TObjectIntMap<String> barcodeCounts, String barcode) {
        barcodeCounts.adjustOrPutValue(barcode, 1, 1);
    }

    private Map<String, List<String>> buildTruncatedHairpinToHairpinIdsMap(Map<String, List<String>> hairpinToHairpinIdsMap) {
        HashMap<String, List<String>> truncatedHairpinToHairpinIdsMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : hairpinToHairpinIdsMap.entrySet()) {
            String hairpin = entry.getKey();
            List<String> hairpinIds = entry.getValue();
            String truncatedHairpin = this.readProcessor.truncateHairpin(hairpin);
            ArrayList<String> hairpinIdsForHairpin = (ArrayList<String>)truncatedHairpinToHairpinIdsMap.get(truncatedHairpin);
            if (hairpinIdsForHairpin == null) {
                hairpinIdsForHairpin = new ArrayList<String>();
                truncatedHairpinToHairpinIdsMap.put(truncatedHairpin, hairpinIdsForHairpin);
            }
            hairpinIdsForHairpin.addAll(hairpinIds);
        }
        return truncatedHairpinToHairpinIdsMap;
    }

    private void countUnexpectedHairpinAndBarcode(String hairpin, String barcode) {
        this.unexpectedReadCountDatabase.countHairpinAndBarcode(hairpin, barcode);
    }

    private PoolQDataOutputs getPoolQDataOutputs() {
        final Map<String, SortedSet<String>> conditionToBarcodeMap = PoolQDataImpl.invertMap(this.poolQDataInputs.getBarcodeToConditionMap(), new HashMap(), new CollectionFactory<String, SortedSet<String>>(){

            @Override
            public SortedSet<String> newCollection() {
                return new TreeSet<String>();
            }
        });
        final TObjectIntMap<String> conditionToMatchingHairpinReadCountMap = this.buildConditionToMatchingHairpinReadCountMap();
        return new PoolQDataOutputs(){

            @Override
            public PoolQScores getPoolQScores() {
                return new PoolQScores(){

                    @Override
                    public Collection<String> getHairpins() {
                        return PoolQDataImpl.this.poolQDataInputs.getHairpinToHairpinIdsMap().keySet();
                    }

                    @Override
                    public Collection<String> getHairpinIdsForHairpin(String hairpin) {
                        return PoolQDataImpl.this.poolQDataInputs.getHairpinToHairpinIdsMap().get(hairpin);
                    }

                    @Override
                    public Map<String, SortedSet<String>> getConditionToBarcodeMap() {
                        return conditionToBarcodeMap;
                    }

                    @Override
                    public List<String> getConditions() {
                        return PoolQDataImpl.this.conditions;
                    }

                    @Override
                    public Map<String, Integer> getScoresByBarcodeForHairpin(String hairpin) {
                        return PoolQDataImpl.this.readCountDatabase.getScoresByBarcodeForHairpin(hairpin);
                    }

                    @Override
                    public Integer getMatchingHairpinReadCountForCondition(String condition) {
                        return conditionToMatchingHairpinReadCountMap.get(condition);
                    }
                };
            }

            @Override
            public QualityReportData getQualityReportData() {
                Map truncatedHairpinToHairpinIdMap = PoolQDataImpl.this.buildTruncatedHairpinToHairpinIdsMap(PoolQDataImpl.this.poolQDataInputs.getHairpinToHairpinIdsMap());
                return new QualityReportDataImpl(PoolQDataImpl.this.poolQDataInputs.getBarcodeLength(), PoolQDataImpl.this.poolQDataInputs.getBarcodeToConditionMap(), PoolQDataImpl.this.barcodeToReadCountMap, PoolQDataImpl.this.barcodeToMatchingHairpinReadCountMap, PoolQDataImpl.this.getTruncatedHairpinToCollidingHairpinIdsMap(truncatedHairpinToHairpinIdMap), PoolQDataImpl.this.numberOfReads, PoolQDataImpl.this.numberOfMatchingReads, PoolQDataImpl.this.numberOfSingleBaseMismatchReads, PoolQDataImpl.this.skippedShortReads);
            }

            @Override
            public UnexpectedSequenceReportData getUnexpectedSequenceReportData() {
                final Map truncatedHairpinToPlatformHairpinIdsMap = PoolQDataImpl.this.buildTruncatedHairpinToHairpinIdsMap(PoolQDataImpl.this.poolQDataInputs.getPlatformHairpinToHairpinIdsMap());
                return new UnexpectedSequenceReportData(){

                    @Override
                    public long getNumberOfReads() {
                        return PoolQDataImpl.this.numberOfReads;
                    }

                    @Override
                    public Iterable<String> getBarcodesMappedToConditions() {
                        return PoolQDataImpl.this.poolQDataInputs.getBarcodeToConditionMap().keySet();
                    }

                    @Override
                    public Iterable<HairpinScore> getUnexpectedHairpins() {
                        return PoolQDataImpl.this.unexpectedReadCountDatabase;
                    }

                    @Override
                    public Collection<String> getPlatformHairpinIdsForHairpin(String hairpin) {
                        Collection hairpinIds = (Collection)truncatedHairpinToPlatformHairpinIdsMap.get(hairpin);
                        if (hairpinIds == null) {
                            return Collections.emptyList();
                        }
                        return hairpinIds;
                    }

                    @Override
                    public Collection<String> getUnexpectedBarcodes() {
                        return PoolQDataImpl.this.unexpectedHairpinUnknownBarcodeReadCount.keySet();
                    }

                    @Override
                    public Integer getUnexpectedHairpinReadCountForBarcode(String barcode) {
                        if (PoolQDataImpl.this.poolQDataInputs.getBarcodeToConditionMap().containsKey(barcode)) {
                            return null;
                        }
                        Integer result = PoolQDataImpl.this.unexpectedHairpinUnknownBarcodeReadCount.get(barcode);
                        if (result == null) {
                            return 0;
                        }
                        return result;
                    }
                };
            }
        };
    }

    private TObjectIntMap<String> buildConditionToMatchingHairpinReadCountMap() {
        final TObjectIntHashMap<String> conditionToMatchingHairpinReadCountMap = new TObjectIntHashMap<String>();
        this.barcodeToMatchingHairpinReadCountMap.forEachEntry(new TObjectIntProcedure<String>(){

            @Override
            public boolean execute(String barcode, int bcReadCount) {
                String condition = PoolQDataImpl.this.poolQDataInputs.getBarcodeToConditionMap().get(barcode);
                conditionToMatchingHairpinReadCountMap.adjustOrPutValue(condition, bcReadCount, bcReadCount);
                return true;
            }
        });
        return conditionToMatchingHairpinReadCountMap;
    }

    private Map<String, Set<String>> getTruncatedHairpinToCollidingHairpinIdsMap(Map<String, List<String>> truncatedHairpinToHairpinIdsMap) {
        LinkedHashMap<String, Set<String>> truncatedHairpinToCollidingHairpinIdsMap = new LinkedHashMap<String, Set<String>>();
        for (String truncatedHairpin : truncatedHairpinToHairpinIdsMap.keySet()) {
            List<String> hairpinIds = truncatedHairpinToHairpinIdsMap.get(truncatedHairpin);
            if (hairpinIds.size() <= 1) continue;
            truncatedHairpinToCollidingHairpinIdsMap.put(truncatedHairpin, new LinkedHashSet<String>(hairpinIds));
        }
        return truncatedHairpinToCollidingHairpinIdsMap;
    }

    static <K, V, C extends Collection<K>> Map<V, C> invertMap(Map<K, V> map, Map<V, C> invertedMap, CollectionFactory<K, C> factory) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value = entry.getValue();
            Collection<Object> collection = (Collection)invertedMap.get(value);
            if (collection == null) {
                collection = factory.newCollection();
                invertedMap.put((Collection)value, (C)collection);
            }
            collection.add(entry.getKey());
        }
        return invertedMap;
    }

    static interface CollectionFactory<E, C extends Collection<E>> {
        public C newCollection();
    }
}

