/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.HairpinScore;
import org.broadinstitute.rnai.poolq.impl.data.HairpinToReadCounts;
import org.broadinstitute.rnai.poolq.impl.data.ReadCountDatabase;
import org.broadinstitute.rnai.poolq.impl.data.ReadOnlyIterator;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabase;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCountTempDatabase
extends TempDatabase
implements ReadCountDatabase {
    private static final Logger logger = LoggerFactory.getLogger(ReadCountTempDatabase.class);
    private final PrimaryIndex<String, HairpinToReadCounts> hairpinIdToConditionToReadCountMapIndex;
    private final List<EntityCursor<HairpinToReadCounts>> openCursors = new ArrayList<EntityCursor<HairpinToReadCounts>>();

    public ReadCountTempDatabase() {
        this.hairpinIdToConditionToReadCountMapIndex = this.getPrimaryIndex(String.class, HairpinToReadCounts.class);
    }

    @Override
    public Iterator<HairpinScore> iterator() {
        try {
            this.setCachePercent(30);
            final EntityCursor cursor = this.hairpinIdToConditionToReadCountMapIndex.entities();
            cursor.setCacheMode(CacheMode.EVICT_LN);
            this.openCursors.add(cursor);
            return new ReadOnlyIterator<HairpinScore>(){
                private final Iterator<HairpinToReadCounts> iterator;
                {
                    this.iterator = cursor.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public HairpinScore next() {
                    return this.iterator.next();
                }
            };
        }
        catch (DatabaseException e) {
            throw new TempDatabaseException(e);
        }
    }

    @Override
    public void prepareForRemoval() {
        for (EntityCursor<HairpinToReadCounts> iterator : this.openCursors) {
            iterator.close();
        }
        super.prepareForRemoval();
    }

    @Override
    public void countHairpinAndBarcode(String hairpin, String barcode) {
        try {
            HairpinToReadCounts hairpinToReadCounts = this.findOrCreateHairpinToReadCounts(hairpin);
            this.incrementReadCountForBarcode(hairpinToReadCounts, barcode);
            this.hairpinIdToConditionToReadCountMapIndex.put(hairpinToReadCounts);
        }
        catch (DatabaseException e) {
            logger.error("Caught database exception while counting hairpin {} and barcode {}", (Object)hairpin, (Object)barcode);
            logger.error("Exception was", e);
            throw new TempDatabaseException(e);
        }
    }

    @Override
    public Integer getScoreForHairpinAndBarcode(String hairpin, String barcode) {
        HairpinToReadCounts readCounts = this.findOrCreateHairpinToReadCounts(hairpin);
        return readCounts.getReadCountsByBarcode().get(barcode);
    }

    @Override
    public Map<String, Integer> getScoresByBarcodeForHairpin(String hairpin) {
        HairpinToReadCounts readCounts = this.findOrCreateHairpinToReadCounts(hairpin);
        return Collections.unmodifiableMap(readCounts.getReadCountsByBarcode());
    }

    private HairpinToReadCounts findOrCreateHairpinToReadCounts(String hairpin) throws DatabaseException {
        HairpinToReadCounts hairpinToReadCounts = this.hairpinIdToConditionToReadCountMapIndex.get(hairpin);
        if (hairpinToReadCounts == null) {
            hairpinToReadCounts = new HairpinToReadCounts();
            hairpinToReadCounts.setHairpin(hairpin);
        }
        return hairpinToReadCounts;
    }

    private void incrementReadCountForBarcode(HairpinToReadCounts hairpinToReadCounts, String barcode) {
        hairpinToReadCounts.incrementCount(barcode);
    }
}

