/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import org.broadinstitute.rnai.poolq.impl.data.ReadTooShortException;

public class ReadProcessor {
    private final int barcodeStartIndex;
    private final int barcodeLength;
    private final int hairpinStartIndex;
    private final int hairpinLength;
    private final int minHairpinLength;
    private final int minReadLength;
    private final int hairpinTruncationLength;

    public ReadProcessor(int readLength, int barcodeStartIndex, int barcodeLength, int hairpinStartIndex, int hairpinLength, int minHairpinLength) {
        this.barcodeStartIndex = barcodeStartIndex;
        this.barcodeLength = barcodeLength;
        this.hairpinStartIndex = hairpinStartIndex;
        this.hairpinLength = hairpinLength;
        this.minHairpinLength = minHairpinLength;
        this.hairpinTruncationLength = this.computeHairpinTruncationLength(readLength);
        int barcodeEndIndex = barcodeStartIndex + barcodeLength;
        int hairpinEndIndex = hairpinStartIndex + this.hairpinTruncationLength;
        this.minReadLength = Math.max(barcodeEndIndex, hairpinEndIndex);
    }

    public String getBarcodeFromRead(String read) {
        return read.substring(this.barcodeStartIndex, this.barcodeStartIndex + this.barcodeLength);
    }

    public String getHairpinFromRead(String read) {
        return read.substring(this.hairpinStartIndex, this.hairpinStartIndex + this.hairpinTruncationLength);
    }

    public String truncateHairpin(String hairpin) {
        if (hairpin.length() > this.hairpinTruncationLength) {
            return hairpin.substring(0, this.hairpinTruncationLength);
        }
        return hairpin;
    }

    public void assertReadIsLongEnough(String read) {
        if (read.length() < this.minReadLength) {
            throw new ReadTooShortException(read, this.minReadLength);
        }
    }

    public boolean isReadLongEnough(String read) {
        return read.length() >= this.minReadLength;
    }

    public int getNCount(String sequence) {
        int nCount = 0;
        int fromIndex = sequence.indexOf(78);
        while (fromIndex > -1) {
            ++nCount;
            fromIndex = sequence.indexOf(78, fromIndex + 1);
        }
        return nCount;
    }

    public boolean hasAtLeastKNs(String sequence, int k) {
        int nCount = 0;
        int fromIndex = sequence.indexOf(78);
        while (fromIndex > -1) {
            if (++nCount >= k) {
                return true;
            }
            fromIndex = sequence.indexOf(78, fromIndex + 1);
        }
        return nCount >= k;
    }

    public boolean hasFewerThanKNs(String sequence, int k) {
        return !this.hasAtLeastKNs(sequence, k);
    }

    private int computeHairpinTruncationLength(int readLength) {
        int maximalHairpinVariantTruncationLength = readLength - this.hairpinStartIndex;
        return Math.max(Math.min(maximalHairpinVariantTruncationLength, this.hairpinLength), this.minHairpinLength);
    }
}

