/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.rnai.poolq.impl.data.HairpinReferenceDatabase;
import org.broadinstitute.rnai.poolq.impl.data.ReadProcessor;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabase;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPhaseHairpinReferenceDatabase
extends TempDatabase
implements HairpinReferenceDatabase {
    private static final Logger logger = LoggerFactory.getLogger(TwoPhaseHairpinReferenceDatabase.class);
    private final Map<String, List<String>> hairpins = new THashMap<String, List<String>>();
    private final PrimaryIndex<String, HairpinEntity> index = this.getPrimaryIndex(String.class, HairpinEntity.class);
    private final ReadProcessor readProcessor;

    public TwoPhaseHairpinReferenceDatabase(ReadProcessor readProcessor) {
        this.readProcessor = readProcessor;
    }

    @Override
    public void buildHairpinVariantDatabase(Set<String> referenceHairpins, boolean includeVariants) {
        logger.info("Building hairpin variant database");
        for (String hairpin : referenceHairpins) {
            String truncatedHairpin = this.readProcessor.truncateHairpin(hairpin);
            List<String> hairpins = this.hairpins.get(truncatedHairpin);
            if (hairpins == null) {
                hairpins = new ArrayList<String>();
                this.hairpins.put(truncatedHairpin, hairpins);
            }
            hairpins.add(hairpin);
            if (!includeVariants) continue;
            for (String signature : this.signaturesOf(truncatedHairpin)) {
                HairpinEntity entity = this.index.get(signature);
                if (entity == null) {
                    this.index.putNoReturn(new HairpinEntity(signature, TwoPhaseHairpinReferenceDatabase.arrayListOf(hairpin)));
                    continue;
                }
                entity.getHairpins().add(hairpin);
                this.index.putNoReturn(entity);
            }
        }
    }

    @Override
    public List<String> getHairpinsForHairpinVariant(String hairpinVariant) {
        if (this.readProcessor.hasFewerThanKNs(hairpinVariant, 2) && this.hairpins.containsKey(hairpinVariant)) {
            return this.hairpins.get(hairpinVariant);
        }
        try {
            LinkedHashSet<String> results = new LinkedHashSet<String>();
            for (String signature : this.signaturesOf(hairpinVariant)) {
                HairpinEntity entity = this.index.get(signature);
                if (entity == null) continue;
                results.addAll(entity.getHairpins());
            }
            return new ArrayList<String>(results);
        }
        catch (DatabaseException e) {
            throw new TempDatabaseException(e);
        }
    }

    static <E> ArrayList<E> arrayListOf(E element) {
        ArrayList<E> list = new ArrayList<E>();
        list.add(element);
        return list;
    }

    Iterable<String> signaturesOf(String hairpin) {
        ArrayList<String> variants = new ArrayList<String>(hairpin.length());
        char[] hairpinChars = hairpin.toCharArray();
        for (int i = 0; i < hairpin.length(); ++i) {
            char original = hairpinChars[i];
            hairpinChars[i] = 78;
            variants.add(new String(hairpinChars));
            hairpinChars[i] = original;
        }
        return variants;
    }

    @Entity
    private static class HairpinEntity {
        @PrimaryKey
        private String signature;
        private List<String> hairpins;

        public HairpinEntity(String signature, List<String> hairpins) {
            this.signature = signature;
            this.hairpins = hairpins;
        }

        public HairpinEntity() {
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public List<String> getHairpins() {
            return this.hairpins;
        }

        public void setHairpins(List<String> hairpins) {
            this.hairpins = hairpins;
        }
    }
}

