/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.rnai.poolq.impl.fileparser.ColumnFileParser;
import org.broadinstitute.rnai.poolq.impl.fileparser.ConditionsFileParserException;

public class ConditionsFileParser {
    private Pattern barcodePattern = Pattern.compile("^[ACGT]+$");
    private Integer barcodeLength = null;

    public Map<String, String> parseBarcodeToConditionMapFromInputStream(InputStream inputStream) throws IOException, ConditionsFileParserException {
        LinkedHashMap<String, String> barcodeToConditionMap = new LinkedHashMap<String, String>();
        int lineNumber = 0;
        for (String[] cells : new ColumnFileParser(inputStream)) {
            ++lineNumber;
            if (cells.length == 0) continue;
            if (cells.length != 2) {
                throw new ConditionsFileParserException.IncorrectNumberOfColumnsException("Line does not contain two columns", lineNumber, cells);
            }
            String barcode = cells[0].trim();
            this.checkBarcodeIsValid(barcode, barcodeToConditionMap, lineNumber, cells);
            String condition = cells[1].trim();
            barcodeToConditionMap.put(barcode, condition);
        }
        if (barcodeToConditionMap.isEmpty()) {
            throw new ConditionsFileParserException.EmptyConditionsFileException("Conditions file is empty", lineNumber);
        }
        return barcodeToConditionMap;
    }

    private void checkBarcodeIsValid(String barcode, Map<String, String> barcodeToConditionMap, int lineNumber, String[] cells) {
        if (!this.barcodeMatchesBarcodePattern(barcode)) {
            throw new ConditionsFileParserException.BadBarcodeException("Barcode '" + barcode + "' is not a valid barcode", lineNumber, cells);
        }
        if (barcodeToConditionMap.containsKey(barcode)) {
            throw new ConditionsFileParserException.DuplicateBarcodeException("Duplicate barcode '" + barcode + "'", lineNumber, cells);
        }
        if (this.barcodeLength == null) {
            this.barcodeLength = barcode.length();
        } else if (!this.barcodeLength.equals(barcode.length())) {
            throw new ConditionsFileParserException.VariableBarcodeLengthException("Barcode '" + barcode + "' does not have the same length as the other barcodes.", lineNumber, cells);
        }
    }

    private boolean barcodeMatchesBarcodePattern(String barcode) {
        Matcher matcher = this.barcodePattern.matcher(barcode);
        return matcher.matches();
    }
}

