/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.impl.TextUtils;

public class ConditionsFileParserException
extends PoolQException {
    private final int lineNumber;
    private final String line;

    public ConditionsFileParserException(String message, int lineNumber, String[] cells) {
        super("Error parsing conditions file (line " + lineNumber + "): " + message);
        this.lineNumber = lineNumber;
        this.line = TextUtils.join(cells, ',');
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLine() {
        return this.line;
    }

    public static class EmptyConditionsFileException
    extends ConditionsFileParserException {
        public EmptyConditionsFileException(String message, int lineNumber) {
            super(message, lineNumber, new String[0]);
        }
    }

    public static class VariableBarcodeLengthException
    extends ConditionsFileParserException {
        public VariableBarcodeLengthException(String message, int lineNumber, String[] cells) {
            super(message, lineNumber, cells);
        }
    }

    public static class DuplicateBarcodeException
    extends ConditionsFileParserException {
        public DuplicateBarcodeException(String message, int lineNumber, String[] cells) {
            super(message, lineNumber, cells);
        }
    }

    public static class BadBarcodeException
    extends ConditionsFileParserException {
        public BadBarcodeException(String message, int lineNumber, String[] cells) {
            super(message, lineNumber, cells);
        }
    }

    public static class IncorrectNumberOfColumnsException
    extends ConditionsFileParserException {
        public IncorrectNumberOfColumnsException(String message, int lineNumber, String[] cells) {
            super(message, lineNumber, cells);
        }
    }
}

