/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.InputStream;
import java.util.Iterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;
import org.broadinstitute.rnai.poolq.impl.fileparser.AbstractReadsIterator;

class SamReadsIterator
extends AbstractReadsIterator {
    private final Iterator<SAMRecord> iterator;
    private final boolean includeNonPf;

    SamReadsIterator(InputStream inputStream, boolean includeNonPf) {
        SAMFileReader samFileReader = new SAMFileReader(inputStream);
        this.iterator = samFileReader.iterator();
        this.includeNonPf = includeNonPf;
    }

    SamReadsIterator(InputStream inputStream) {
        this(inputStream, true);
    }

    @Override
    protected String getNextRead() {
        while (this.iterator.hasNext()) {
            SAMRecord next = this.iterator.next();
            if (next.getReadFailsVendorQualityCheckFlag() && !this.includeNonPf) continue;
            if (next.getReadNegativeStrandFlag()) {
                return SequenceUtil.reverseComplement(next.getReadString());
            }
            return next.getReadString();
        }
        return null;
    }
}

