/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.EnhancedAccessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PersistentProxy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Persistent
abstract class MapProxy<K, V>
implements PersistentProxy<Map<K, V>> {
    private K[] keys;
    private V[] values;

    protected MapProxy() {
    }

    @Override
    public final void initializeProxy(Map<K, V> map2) {
        int size2 = map2.size();
        this.keys = new Object[size2];
        this.values = new Object[size2];
        int i = 0;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.keys[i] = entry.getKey();
            this.values[i] = entry.getValue();
            ++i;
        }
    }

    @Override
    public final Map<K, V> convertProxy() {
        int size2 = this.values.length;
        Map<K, V> map2 = this.newInstance(size2);
        for (int i = 0; i < size2; ++i) {
            map2.put(this.keys[i], this.values[i]);
        }
        return map2;
    }

    protected abstract Map<K, V> newInstance(int var1);

    public Object bdbNewInstance() {
        return null;
    }

    public Object bdbNewArray(int n) {
        return null;
    }

    public boolean bdbIsPriKeyFieldNullOrZero() {
        return false;
    }

    public void bdbWritePriKeyField(EntityOutput entityOutput, Format format2) {
    }

    public void bdbReadPriKeyField(EntityInput entityInput, Format format2) {
    }

    public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
    }

    public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
    }

    public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
        entityOutput.writeObject(this.keys, null);
        entityOutput.writeObject(this.values, null);
    }

    public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
        if (n3 <= 0) {
            switch (n) {
                case 0: {
                    this.keys = (Object[])entityInput.readObject();
                    if (n2 == 0) break;
                }
                case 1: {
                    this.values = (Object[])entityInput.readObject();
                }
            }
        }
    }

    public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
    }

    public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
    }

    public Object bdbGetField(Object object, int n, int n2, boolean bl) {
        if (n2 <= 0 && !bl) {
            switch (n) {
                case 0: {
                    return this.keys;
                }
                case 1: {
                    return this.values;
                }
            }
        }
        return null;
    }

    public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
        if (n2 > 0) {
            return;
        }
        if (!bl) {
            switch (n) {
                case 0: {
                    this.keys = (Object[])object2;
                    return;
                }
                case 1: {
                    this.values = (Object[])object2;
                    return;
                }
            }
        }
    }

    public void bdbSetPriField(Object object, Object object2) {
    }

    static {
        EnhancedAccessor.registerClass("com.sleepycat.persist.impl.MapProxy", null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Persistent(proxyFor=LinkedHashMap.class)
    static class LinkedHashMapProxy<K, V>
    extends MapProxy<K, V> {
        protected LinkedHashMapProxy() {
        }

        @Override
        protected Map<K, V> newInstance(int size2) {
            return new LinkedHashMap();
        }

        @Override
        public Object bdbNewInstance() {
            return new LinkedHashMapProxy<K, V>();
        }

        @Override
        public Object bdbNewArray(int n) {
            return new LinkedHashMapProxy[n];
        }

        @Override
        public boolean bdbIsPriKeyFieldNullOrZero() {
            return super.bdbIsPriKeyFieldNullOrZero();
        }

        @Override
        public void bdbWritePriKeyField(EntityOutput entityOutput, Format format2) {
            super.bdbWritePriKeyField(entityOutput, format2);
        }

        @Override
        public void bdbReadPriKeyField(EntityInput entityInput, Format format2) {
            super.bdbReadPriKeyField(entityInput, format2);
        }

        @Override
        public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
            super.bdbWriteSecKeyFields(entityOutput);
        }

        @Override
        public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadSecKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
            super.bdbWriteNonKeyFields(entityOutput);
        }

        @Override
        public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadNonKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
        }

        @Override
        public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
        }

        @Override
        public Object bdbGetField(Object object, int n, int n2, boolean bl) {
            if (n2 > 0) {
                return this.bdbGetField(object, n, n2 - 1, bl);
            }
            if (bl) {
                // empty if block
            }
            return null;
        }

        @Override
        public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
            if (n2 > 0) {
                this.bdbSetField(object, n, n2 - 1, bl, object2);
                return;
            }
            if (bl) {
                // empty if block
            }
        }

        @Override
        public void bdbSetPriField(Object object, Object object2) {
            super.bdbSetPriField(object, object2);
        }

        static {
            EnhancedAccessor.registerClass("com.sleepycat.persist.impl.MapProxy$LinkedHashMapProxy", new LinkedHashMapProxy());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Persistent(proxyFor=TreeMap.class)
    static class TreeMapProxy<K, V>
    extends MapProxy<K, V> {
        protected TreeMapProxy() {
        }

        @Override
        protected Map<K, V> newInstance(int size2) {
            return new TreeMap();
        }

        @Override
        public Object bdbNewInstance() {
            return new TreeMapProxy<K, V>();
        }

        @Override
        public Object bdbNewArray(int n) {
            return new TreeMapProxy[n];
        }

        @Override
        public boolean bdbIsPriKeyFieldNullOrZero() {
            return super.bdbIsPriKeyFieldNullOrZero();
        }

        @Override
        public void bdbWritePriKeyField(EntityOutput entityOutput, Format format2) {
            super.bdbWritePriKeyField(entityOutput, format2);
        }

        @Override
        public void bdbReadPriKeyField(EntityInput entityInput, Format format2) {
            super.bdbReadPriKeyField(entityInput, format2);
        }

        @Override
        public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
            super.bdbWriteSecKeyFields(entityOutput);
        }

        @Override
        public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadSecKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
            super.bdbWriteNonKeyFields(entityOutput);
        }

        @Override
        public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadNonKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
        }

        @Override
        public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
        }

        @Override
        public Object bdbGetField(Object object, int n, int n2, boolean bl) {
            if (n2 > 0) {
                return this.bdbGetField(object, n, n2 - 1, bl);
            }
            if (bl) {
                // empty if block
            }
            return null;
        }

        @Override
        public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
            if (n2 > 0) {
                this.bdbSetField(object, n, n2 - 1, bl, object2);
                return;
            }
            if (bl) {
                // empty if block
            }
        }

        @Override
        public void bdbSetPriField(Object object, Object object2) {
            super.bdbSetPriField(object, object2);
        }

        static {
            EnhancedAccessor.registerClass("com.sleepycat.persist.impl.MapProxy$TreeMapProxy", new TreeMapProxy());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Persistent(proxyFor=HashMap.class)
    static class HashMapProxy<K, V>
    extends MapProxy<K, V> {
        protected HashMapProxy() {
        }

        @Override
        protected Map<K, V> newInstance(int size2) {
            return new HashMap(size2);
        }

        @Override
        public Object bdbNewInstance() {
            return new HashMapProxy<K, V>();
        }

        @Override
        public Object bdbNewArray(int n) {
            return new HashMapProxy[n];
        }

        @Override
        public boolean bdbIsPriKeyFieldNullOrZero() {
            return super.bdbIsPriKeyFieldNullOrZero();
        }

        @Override
        public void bdbWritePriKeyField(EntityOutput entityOutput, Format format2) {
            super.bdbWritePriKeyField(entityOutput, format2);
        }

        @Override
        public void bdbReadPriKeyField(EntityInput entityInput, Format format2) {
            super.bdbReadPriKeyField(entityInput, format2);
        }

        @Override
        public void bdbWriteSecKeyFields(EntityOutput entityOutput) {
            super.bdbWriteSecKeyFields(entityOutput);
        }

        @Override
        public void bdbReadSecKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadSecKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteNonKeyFields(EntityOutput entityOutput) {
            super.bdbWriteNonKeyFields(entityOutput);
        }

        @Override
        public void bdbReadNonKeyFields(EntityInput entityInput, int n, int n2, int n3) {
            if (n3 != 0) {
                super.bdbReadNonKeyFields(entityInput, n, n2, n3 - 1);
            }
        }

        @Override
        public void bdbWriteCompositeKeyFields(EntityOutput entityOutput, Format[] formatArray) {
        }

        @Override
        public void bdbReadCompositeKeyFields(EntityInput entityInput, Format[] formatArray) {
        }

        @Override
        public Object bdbGetField(Object object, int n, int n2, boolean bl) {
            if (n2 > 0) {
                return this.bdbGetField(object, n, n2 - 1, bl);
            }
            if (bl) {
                // empty if block
            }
            return null;
        }

        @Override
        public void bdbSetField(Object object, int n, int n2, boolean bl, Object object2) {
            if (n2 > 0) {
                this.bdbSetField(object, n, n2 - 1, bl, object2);
                return;
            }
            if (bl) {
                // empty if block
            }
        }

        @Override
        public void bdbSetPriField(Object object, Object object2) {
            super.bdbSetPriField(object, object2);
        }

        static {
            EnhancedAccessor.registerClass("com.sleepycat.persist.impl.MapProxy$HashMapProxy", new HashMapProxy());
        }
    }
}

