/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.math.RoundingMode;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.picard.PicardException;
import net.sf.samtools.util.Iso8601Date;

public class FormatUtil {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private NumberFormat integerFormat = NumberFormat.getIntegerInstance();
    private NumberFormat floatFormat;

    public FormatUtil() {
        this.integerFormat.setGroupingUsed(false);
        this.floatFormat = NumberFormat.getNumberInstance();
        this.floatFormat.setGroupingUsed(false);
        this.floatFormat.setMaximumFractionDigits(6);
        this.floatFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        if (this.floatFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)this.floatFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setNaN("?");
            decimalFormatSymbols.setInfinity("?");
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    public String format(short s2) {
        return this.integerFormat.format(s2);
    }

    public String format(int n) {
        return this.integerFormat.format(n);
    }

    public String format(long l) {
        return this.integerFormat.format(l);
    }

    public String format(float f) {
        return this.floatFormat.format(f);
    }

    public String format(double d) {
        return this.floatFormat.format(d);
    }

    public String format(Enum enum_) {
        return enum_.name();
    }

    public String format(Date date) {
        return this.dateFormat.format(date);
    }

    public String format(Iso8601Date iso8601Date) {
        return iso8601Date.toString();
    }

    public String format(boolean bl) {
        if (bl) {
            return "Y";
        }
        return "N";
    }

    public String format(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Short) {
            return this.format((Short)object);
        }
        if (object instanceof Integer) {
            return this.format((Integer)object);
        }
        if (object instanceof Long) {
            return this.format((Long)object);
        }
        if (object instanceof Float) {
            return this.format(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.format((Double)object);
        }
        if (object instanceof Enum) {
            return this.format((Enum)object);
        }
        if (object instanceof Iso8601Date) {
            return this.format((Iso8601Date)object);
        }
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof Boolean) {
            return this.format((Boolean)object);
        }
        return object.toString();
    }

    public short parseShort(String string2) {
        return Short.parseShort(string2);
    }

    public int parseInt(String string2) {
        return Integer.parseInt(string2);
    }

    public long parseLong(String string2) {
        return Long.parseLong(string2);
    }

    public float parseFloat(String string2) {
        if ("?".equals(string2) || "-?".equals(string2)) {
            return Float.NaN;
        }
        return Float.parseFloat(string2);
    }

    public double parseDouble(String string2) {
        if ("?".equals(string2) || "-?".equals(string2)) {
            return Double.NaN;
        }
        return Double.parseDouble(string2);
    }

    public <E extends Enum> E parseEnum(String string2, Class<E> clazz) {
        return Enum.valueOf(clazz, string2);
    }

    public Date parseDate(String string2) {
        try {
            return this.dateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            throw new PicardException("Could not parse value as date: " + string2, parseException);
        }
    }

    public Iso8601Date parseIso8601Date(String string2) {
        return new Iso8601Date(string2);
    }

    public boolean parseBoolean(String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        char c = Character.toUpperCase(string2.charAt(0));
        return c == 'Y';
    }

    public Object parseObject(String string2, Class<?> clazz) {
        if (clazz == Short.class || clazz == Short.TYPE) {
            return this.parseShort(string2);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return this.parseInt(string2);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return this.parseLong(string2);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(this.parseFloat(string2));
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return this.parseDouble(string2);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return this.parseBoolean(string2);
        }
        if (clazz == Iso8601Date.class) {
            return this.parseIso8601Date(string2);
        }
        if (clazz == Date.class) {
            return this.parseDate(string2);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return this.parseInt(string2);
        }
        if (clazz == File.class) {
            return new File(string2);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return this.parseEnum(string2, clazz);
        }
        if (clazz == String.class) {
            return string2;
        }
        throw new InvalidParameterException("Don't know how to convert a String to a " + clazz.getName());
    }
}

